// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The HLS setting for a track. </summary>
    public partial class HlsSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HlsSettings"/>. </summary>
        public HlsSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HlsSettings"/>. </summary>
        /// <param name="isDefault"> The default for the HLS setting. </param>
        /// <param name="isForced"> The forced for the HLS setting. </param>
        /// <param name="characteristics"> The characteristics for the HLS setting. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HlsSettings(bool? isDefault, bool? isForced, string characteristics, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsDefault = isDefault;
            IsForced = isForced;
            Characteristics = characteristics;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The default for the HLS setting. </summary>
        public bool? IsDefault { get; set; }
        /// <summary> The forced for the HLS setting. </summary>
        public bool? IsForced { get; set; }
        /// <summary> The characteristics for the HLS setting. </summary>
        public string Characteristics { get; set; }
    }
}
