// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> We currently support Baseline, Main, High, High422, High444. Default is Auto. </summary>
    public readonly partial struct H264VideoProfile : IEquatable<H264VideoProfile>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="H264VideoProfile"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public H264VideoProfile(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string BaselineValue = "Baseline";
        private const string MainValue = "Main";
        private const string HighValue = "High";
        private const string High422Value = "High422";
        private const string High444Value = "High444";

        /// <summary> Tells the encoder to automatically determine the appropriate H.264 profile. </summary>
        public static H264VideoProfile Auto { get; } = new H264VideoProfile(AutoValue);
        /// <summary> Baseline profile. </summary>
        public static H264VideoProfile Baseline { get; } = new H264VideoProfile(BaselineValue);
        /// <summary> Main profile. </summary>
        public static H264VideoProfile Main { get; } = new H264VideoProfile(MainValue);
        /// <summary> High profile. </summary>
        public static H264VideoProfile High { get; } = new H264VideoProfile(HighValue);
        /// <summary> High 4:2:2 profile. </summary>
        public static H264VideoProfile High422 { get; } = new H264VideoProfile(High422Value);
        /// <summary> High 4:4:4 predictive profile. </summary>
        public static H264VideoProfile High444 { get; } = new H264VideoProfile(High444Value);
        /// <summary> Determines if two <see cref="H264VideoProfile"/> values are the same. </summary>
        public static bool operator ==(H264VideoProfile left, H264VideoProfile right) => left.Equals(right);
        /// <summary> Determines if two <see cref="H264VideoProfile"/> values are not the same. </summary>
        public static bool operator !=(H264VideoProfile left, H264VideoProfile right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="H264VideoProfile"/>. </summary>
        public static implicit operator H264VideoProfile(string value) => new H264VideoProfile(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is H264VideoProfile other && Equals(other);
        /// <inheritdoc />
        public bool Equals(H264VideoProfile other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
