// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Tells the encoder how to choose its encoding settings. The default value is Balanced. </summary>
    public readonly partial struct H264Complexity : IEquatable<H264Complexity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="H264Complexity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public H264Complexity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SpeedValue = "Speed";
        private const string BalancedValue = "Balanced";
        private const string QualityValue = "Quality";

        /// <summary> Tells the encoder to use settings that are optimized for faster encoding. Quality is sacrificed to decrease encoding time. </summary>
        public static H264Complexity Speed { get; } = new H264Complexity(SpeedValue);
        /// <summary> Tells the encoder to use settings that achieve a balance between speed and quality. </summary>
        public static H264Complexity Balanced { get; } = new H264Complexity(BalancedValue);
        /// <summary> Tells the encoder to use settings that are optimized to produce higher quality output at the expense of slower overall encode time. </summary>
        public static H264Complexity Quality { get; } = new H264Complexity(QualityValue);
        /// <summary> Determines if two <see cref="H264Complexity"/> values are the same. </summary>
        public static bool operator ==(H264Complexity left, H264Complexity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="H264Complexity"/> values are not the same. </summary>
        public static bool operator !=(H264Complexity left, H264Complexity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="H264Complexity"/>. </summary>
        public static implicit operator H264Complexity(string value) => new H264Complexity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is H264Complexity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(H264Complexity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
