// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation. </summary>
    public partial class FilterTrackSelection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FilterTrackSelection"/>. </summary>
        /// <param name="trackSelections"> The track selections. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="trackSelections"/> is null. </exception>
        public FilterTrackSelection(IEnumerable<FilterTrackPropertyCondition> trackSelections)
        {
            Argument.AssertNotNull(trackSelections, nameof(trackSelections));

            TrackSelections = trackSelections.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="FilterTrackSelection"/>. </summary>
        /// <param name="trackSelections"> The track selections. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FilterTrackSelection(IList<FilterTrackPropertyCondition> trackSelections, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TrackSelections = trackSelections;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FilterTrackSelection"/> for deserialization. </summary>
        internal FilterTrackSelection()
        {
        }

        /// <summary> The track selections. </summary>
        public IList<FilterTrackPropertyCondition> TrackSelections { get; }
    }
}
