// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class FilterTrackSelection : IUtf8JsonSerializable, IJsonModel<FilterTrackSelection>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FilterTrackSelection>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FilterTrackSelection>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FilterTrackSelection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FilterTrackSelection)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("trackSelections"u8);
            writer.WriteStartArray();
            foreach (var item in TrackSelections)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FilterTrackSelection IJsonModel<FilterTrackSelection>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FilterTrackSelection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FilterTrackSelection)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFilterTrackSelection(document.RootElement, options);
        }

        internal static FilterTrackSelection DeserializeFilterTrackSelection(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<FilterTrackPropertyCondition> trackSelections = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("trackSelections"u8))
                {
                    List<FilterTrackPropertyCondition> array = new List<FilterTrackPropertyCondition>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FilterTrackPropertyCondition.DeserializeFilterTrackPropertyCondition(item, options));
                    }
                    trackSelections = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FilterTrackSelection(trackSelections, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FilterTrackSelection>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FilterTrackSelection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FilterTrackSelection)} does not support writing '{options.Format}' format.");
            }
        }

        FilterTrackSelection IPersistableModel<FilterTrackSelection>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FilterTrackSelection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFilterTrackSelection(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FilterTrackSelection)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FilterTrackSelection>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
