// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The track property type. </summary>
    public readonly partial struct FilterTrackPropertyType : IEquatable<FilterTrackPropertyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FilterTrackPropertyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FilterTrackPropertyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string TypeValue = "Type";
        private const string NameValue = "Name";
        private const string LanguageValue = "Language";
        private const string FourCCValue = "FourCC";
        private const string BitrateValue = "Bitrate";

        /// <summary> The unknown track property type. </summary>
        public static FilterTrackPropertyType Unknown { get; } = new FilterTrackPropertyType(UnknownValue);
        /// <summary> The type. </summary>
        public static FilterTrackPropertyType Type { get; } = new FilterTrackPropertyType(TypeValue);
        /// <summary> The name. </summary>
        public static FilterTrackPropertyType Name { get; } = new FilterTrackPropertyType(NameValue);
        /// <summary> The language. </summary>
        public static FilterTrackPropertyType Language { get; } = new FilterTrackPropertyType(LanguageValue);
        /// <summary> The fourCC. </summary>
        public static FilterTrackPropertyType FourCC { get; } = new FilterTrackPropertyType(FourCCValue);
        /// <summary> The bitrate. </summary>
        public static FilterTrackPropertyType Bitrate { get; } = new FilterTrackPropertyType(BitrateValue);
        /// <summary> Determines if two <see cref="FilterTrackPropertyType"/> values are the same. </summary>
        public static bool operator ==(FilterTrackPropertyType left, FilterTrackPropertyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FilterTrackPropertyType"/> values are not the same. </summary>
        public static bool operator !=(FilterTrackPropertyType left, FilterTrackPropertyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FilterTrackPropertyType"/>. </summary>
        public static implicit operator FilterTrackPropertyType(string value) => new FilterTrackPropertyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FilterTrackPropertyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FilterTrackPropertyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
