// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The track property condition operation. </summary>
    public readonly partial struct FilterTrackPropertyCompareOperation : IEquatable<FilterTrackPropertyCompareOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FilterTrackPropertyCompareOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FilterTrackPropertyCompareOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualValue = "Equal";
        private const string NotEqualValue = "NotEqual";

        /// <summary> The equal operation. </summary>
        public static FilterTrackPropertyCompareOperation Equal { get; } = new FilterTrackPropertyCompareOperation(EqualValue);
        /// <summary> The not equal operation. </summary>
        public static FilterTrackPropertyCompareOperation NotEqual { get; } = new FilterTrackPropertyCompareOperation(NotEqualValue);
        /// <summary> Determines if two <see cref="FilterTrackPropertyCompareOperation"/> values are the same. </summary>
        public static bool operator ==(FilterTrackPropertyCompareOperation left, FilterTrackPropertyCompareOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FilterTrackPropertyCompareOperation"/> values are not the same. </summary>
        public static bool operator !=(FilterTrackPropertyCompareOperation left, FilterTrackPropertyCompareOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FilterTrackPropertyCompareOperation"/>. </summary>
        public static implicit operator FilterTrackPropertyCompareOperation(string value) => new FilterTrackPropertyCompareOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FilterTrackPropertyCompareOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FilterTrackPropertyCompareOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
