// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The built-in preset to be used for encoding videos. </summary>
    public readonly partial struct EncoderNamedPreset : IEquatable<EncoderNamedPreset>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EncoderNamedPreset"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EncoderNamedPreset(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string H264SingleBitrateSDValue = "H264SingleBitrateSD";
        private const string H264SingleBitrate720PValue = "H264SingleBitrate720p";
        private const string H264SingleBitrate1080PValue = "H264SingleBitrate1080p";
        private const string AdaptiveStreamingValue = "AdaptiveStreaming";
        private const string AacGoodQualityAudioValue = "AACGoodQualityAudio";
        private const string DDGoodQualityAudioValue = "DDGoodQualityAudio";
        private const string ContentAwareEncodingExperimentalValue = "ContentAwareEncodingExperimental";
        private const string ContentAwareEncodingValue = "ContentAwareEncoding";
        private const string CopyAllBitrateNonInterleavedValue = "CopyAllBitrateNonInterleaved";
        private const string H264MultipleBitrate1080PValue = "H264MultipleBitrate1080p";
        private const string H264MultipleBitrate720PValue = "H264MultipleBitrate720p";
        private const string H264MultipleBitrateSDValue = "H264MultipleBitrateSD";
        private const string H265ContentAwareEncodingValue = "H265ContentAwareEncoding";
        private const string H265AdaptiveStreamingValue = "H265AdaptiveStreaming";
        private const string H265SingleBitrate720PValue = "H265SingleBitrate720p";
        private const string H265SingleBitrate1080PValue = "H265SingleBitrate1080p";
        private const string H265SingleBitrate4KValue = "H265SingleBitrate4K";

        /// <summary> Produces an MP4 file where the video is encoded with H.264 codec at 2200 kbps and a picture height of 480 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H264SingleBitrateSD { get; } = new EncoderNamedPreset(H264SingleBitrateSDValue);
        /// <summary> Produces an MP4 file where the video is encoded with H.264 codec at 4500 kbps and a picture height of 720 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H264SingleBitrate720P { get; } = new EncoderNamedPreset(H264SingleBitrate720PValue);
        /// <summary> Produces an MP4 file where the video is encoded with H.264 codec at 6750 kbps and a picture height of 1080 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H264SingleBitrate1080P { get; } = new EncoderNamedPreset(H264SingleBitrate1080PValue);
        /// <summary> Produces a set of GOP aligned MP4 files with H.264 video and stereo AAC audio. Auto-generates a bitrate ladder based on the input resolution, bitrate and frame rate. The auto-generated preset will never exceed the input resolution. For example, if the input is 720p, output will remain 720p at best. </summary>
        public static EncoderNamedPreset AdaptiveStreaming { get; } = new EncoderNamedPreset(AdaptiveStreamingValue);
        /// <summary> Produces a single MP4 file containing only AAC stereo audio encoded at 192 kbps. </summary>
        public static EncoderNamedPreset AacGoodQualityAudio { get; } = new EncoderNamedPreset(AacGoodQualityAudioValue);
        /// <summary> Produces a single MP4 file containing only DD(Digital Dolby) stereo audio encoded at 192 kbps. </summary>
        public static EncoderNamedPreset DDGoodQualityAudio { get; } = new EncoderNamedPreset(DDGoodQualityAudioValue);
        /// <summary> Exposes an experimental preset for content-aware encoding. Given any input content, the service attempts to automatically determine the optimal number of layers, appropriate bitrate and resolution settings for delivery by adaptive streaming. The underlying algorithms will continue to evolve over time. The output will contain MP4 files with video and audio interleaved. </summary>
        public static EncoderNamedPreset ContentAwareEncodingExperimental { get; } = new EncoderNamedPreset(ContentAwareEncodingExperimentalValue);
        /// <summary> Produces a set of GOP-aligned MP4s by using content-aware encoding. Given any input content, the service performs an initial lightweight analysis of the input content, and uses the results to determine the optimal number of layers, appropriate bitrate and resolution settings for delivery by adaptive streaming. This preset is particularly effective for low and medium complexity videos, where the output files will be at lower bitrates but at a quality that still delivers a good experience to viewers. The output will contain MP4 files with video and audio interleaved. </summary>
        public static EncoderNamedPreset ContentAwareEncoding { get; } = new EncoderNamedPreset(ContentAwareEncodingValue);
        /// <summary> Copy all video and audio streams from the input asset as non-interleaved video and audio output files. This preset can be used to clip an existing asset or convert a group of key frame (GOP) aligned MP4 files as an asset that can be streamed. </summary>
        public static EncoderNamedPreset CopyAllBitrateNonInterleaved { get; } = new EncoderNamedPreset(CopyAllBitrateNonInterleavedValue);
        /// <summary> Produces a set of 8 GOP-aligned MP4 files, ranging from 6000 kbps to 400 kbps, and stereo AAC audio. Resolution starts at 1080p and goes down to 180p. </summary>
        public static EncoderNamedPreset H264MultipleBitrate1080P { get; } = new EncoderNamedPreset(H264MultipleBitrate1080PValue);
        /// <summary> Produces a set of 6 GOP-aligned MP4 files, ranging from 3400 kbps to 400 kbps, and stereo AAC audio. Resolution starts at 720p and goes down to 180p. </summary>
        public static EncoderNamedPreset H264MultipleBitrate720P { get; } = new EncoderNamedPreset(H264MultipleBitrate720PValue);
        /// <summary> Produces a set of 5 GOP-aligned MP4 files, ranging from 1900kbps to 400 kbps, and stereo AAC audio. Resolution starts at 480p and goes down to 240p. </summary>
        public static EncoderNamedPreset H264MultipleBitrateSD { get; } = new EncoderNamedPreset(H264MultipleBitrateSDValue);
        /// <summary> Produces a set of GOP-aligned MP4s by using content-aware encoding. Given any input content, the service performs an initial lightweight analysis of the input content, and uses the results to determine the optimal number of layers, appropriate bitrate and resolution settings for delivery by adaptive streaming. This preset is particularly effective for low and medium complexity videos, where the output files will be at lower bitrates but at a quality that still delivers a good experience to viewers. The output will contain MP4 files with video and audio interleaved. </summary>
        public static EncoderNamedPreset H265ContentAwareEncoding { get; } = new EncoderNamedPreset(H265ContentAwareEncodingValue);
        /// <summary> Produces a set of GOP aligned MP4 files with H.265 video and stereo AAC audio. Auto-generates a bitrate ladder based on the input resolution, bitrate and frame rate. The auto-generated preset will never exceed the input resolution. For example, if the input is 720p, output will remain 720p at best. </summary>
        public static EncoderNamedPreset H265AdaptiveStreaming { get; } = new EncoderNamedPreset(H265AdaptiveStreamingValue);
        /// <summary> Produces an MP4 file where the video is encoded with H.265 codec at 1800 kbps and a picture height of 720 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H265SingleBitrate720P { get; } = new EncoderNamedPreset(H265SingleBitrate720PValue);
        /// <summary> Produces an MP4 file where the video is encoded with H.265 codec at 3500 kbps and a picture height of 1080 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H265SingleBitrate1080P { get; } = new EncoderNamedPreset(H265SingleBitrate1080PValue);
        /// <summary> Produces an MP4 file where the video is encoded with H.265 codec at 9500 kbps and a picture height of 2160 pixels, and the stereo audio is encoded with AAC-LC codec at 128 kbps. </summary>
        public static EncoderNamedPreset H265SingleBitrate4K { get; } = new EncoderNamedPreset(H265SingleBitrate4KValue);
        /// <summary> Determines if two <see cref="EncoderNamedPreset"/> values are the same. </summary>
        public static bool operator ==(EncoderNamedPreset left, EncoderNamedPreset right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EncoderNamedPreset"/> values are not the same. </summary>
        public static bool operator !=(EncoderNamedPreset left, EncoderNamedPreset right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EncoderNamedPreset"/>. </summary>
        public static implicit operator EncoderNamedPreset(string value) => new EncoderNamedPreset(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EncoderNamedPreset other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EncoderNamedPreset other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
