// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The field parity for de-interlacing, defaults to Auto. </summary>
    public readonly partial struct DeinterlaceParity : IEquatable<DeinterlaceParity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeinterlaceParity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeinterlaceParity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string TopFieldFirstValue = "TopFieldFirst";
        private const string BottomFieldFirstValue = "BottomFieldFirst";

        /// <summary> Automatically detect the order of fields. </summary>
        public static DeinterlaceParity Auto { get; } = new DeinterlaceParity(AutoValue);
        /// <summary> Apply top field first processing of input video. </summary>
        public static DeinterlaceParity TopFieldFirst { get; } = new DeinterlaceParity(TopFieldFirstValue);
        /// <summary> Apply bottom field first processing of input video. </summary>
        public static DeinterlaceParity BottomFieldFirst { get; } = new DeinterlaceParity(BottomFieldFirstValue);
        /// <summary> Determines if two <see cref="DeinterlaceParity"/> values are the same. </summary>
        public static bool operator ==(DeinterlaceParity left, DeinterlaceParity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeinterlaceParity"/> values are not the same. </summary>
        public static bool operator !=(DeinterlaceParity left, DeinterlaceParity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeinterlaceParity"/>. </summary>
        public static implicit operator DeinterlaceParity(string value) => new DeinterlaceParity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeinterlaceParity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeinterlaceParity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
