// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The deinterlacing mode. Defaults to AutoPixelAdaptive. </summary>
    public readonly partial struct DeinterlaceMode : IEquatable<DeinterlaceMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeinterlaceMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeinterlaceMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OffValue = "Off";
        private const string AutoPixelAdaptiveValue = "AutoPixelAdaptive";

        /// <summary> Disables de-interlacing of the source video. </summary>
        public static DeinterlaceMode Off { get; } = new DeinterlaceMode(OffValue);
        /// <summary> Apply automatic pixel adaptive de-interlacing on each frame in the input video. </summary>
        public static DeinterlaceMode AutoPixelAdaptive { get; } = new DeinterlaceMode(AutoPixelAdaptiveValue);
        /// <summary> Determines if two <see cref="DeinterlaceMode"/> values are the same. </summary>
        public static bool operator ==(DeinterlaceMode left, DeinterlaceMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeinterlaceMode"/> values are not the same. </summary>
        public static bool operator !=(DeinterlaceMode left, DeinterlaceMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeinterlaceMode"/>. </summary>
        public static implicit operator DeinterlaceMode(string value) => new DeinterlaceMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeinterlaceMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeinterlaceMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
