// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The client access policy. </summary>
    public partial class CrossSiteAccessPolicies
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CrossSiteAccessPolicies"/>. </summary>
        public CrossSiteAccessPolicies()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CrossSiteAccessPolicies"/>. </summary>
        /// <param name="clientAccessPolicy"> The content of clientaccesspolicy.xml used by Silverlight. </param>
        /// <param name="crossDomainPolicy"> The content of crossdomain.xml used by Silverlight. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CrossSiteAccessPolicies(string clientAccessPolicy, string crossDomainPolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientAccessPolicy = clientAccessPolicy;
            CrossDomainPolicy = crossDomainPolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The content of clientaccesspolicy.xml used by Silverlight. </summary>
        public string ClientAccessPolicy { get; set; }
        /// <summary> The content of crossdomain.xml used by Silverlight. </summary>
        public string CrossDomainPolicy { get; set; }
    }
}
