// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class CrossSiteAccessPolicies : IUtf8JsonSerializable, IJsonModel<CrossSiteAccessPolicies>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CrossSiteAccessPolicies>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CrossSiteAccessPolicies>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSiteAccessPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CrossSiteAccessPolicies)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ClientAccessPolicy))
            {
                writer.WritePropertyName("clientAccessPolicy"u8);
                writer.WriteStringValue(ClientAccessPolicy);
            }
            if (Optional.IsDefined(CrossDomainPolicy))
            {
                writer.WritePropertyName("crossDomainPolicy"u8);
                writer.WriteStringValue(CrossDomainPolicy);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CrossSiteAccessPolicies IJsonModel<CrossSiteAccessPolicies>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSiteAccessPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CrossSiteAccessPolicies)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCrossSiteAccessPolicies(document.RootElement, options);
        }

        internal static CrossSiteAccessPolicies DeserializeCrossSiteAccessPolicies(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clientAccessPolicy = default;
            string crossDomainPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clientAccessPolicy"u8))
                {
                    clientAccessPolicy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("crossDomainPolicy"u8))
                {
                    crossDomainPolicy = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CrossSiteAccessPolicies(clientAccessPolicy, crossDomainPolicy, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CrossSiteAccessPolicies>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSiteAccessPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CrossSiteAccessPolicies)} does not support writing '{options.Format}' format.");
            }
        }

        CrossSiteAccessPolicies IPersistableModel<CrossSiteAccessPolicies>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSiteAccessPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCrossSiteAccessPolicies(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CrossSiteAccessPolicies)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CrossSiteAccessPolicies>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
