// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Specifies a configuration for Widevine licenses. </summary>
    public partial class ContentKeyPolicyWidevineConfiguration : ContentKeyPolicyConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyWidevineConfiguration"/>. </summary>
        /// <param name="widevineTemplate"> The Widevine template. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="widevineTemplate"/> is null. </exception>
        public ContentKeyPolicyWidevineConfiguration(string widevineTemplate)
        {
            Argument.AssertNotNull(widevineTemplate, nameof(widevineTemplate));

            WidevineTemplate = widevineTemplate;
            OdataType = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyWidevineConfiguration"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="widevineTemplate"> The Widevine template. </param>
        internal ContentKeyPolicyWidevineConfiguration(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, string widevineTemplate) : base(odataType, serializedAdditionalRawData)
        {
            WidevineTemplate = widevineTemplate;
            OdataType = odataType ?? "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyWidevineConfiguration"/> for deserialization. </summary>
        internal ContentKeyPolicyWidevineConfiguration()
        {
        }

        /// <summary> The Widevine template. </summary>
        public string WidevineTemplate { get; set; }
    }
}
