// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Represents a token restriction. Provided token must match these requirements for successful license or key delivery. </summary>
    public partial class ContentKeyPolicyTokenRestriction : ContentKeyPolicyRestriction
    {
        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyTokenRestriction"/>. </summary>
        /// <param name="issuer"> The token issuer. </param>
        /// <param name="audience"> The audience for the token. </param>
        /// <param name="primaryVerificationKey">
        /// The primary verification key.
        /// Please note <see cref="ContentKeyPolicyRestrictionTokenKey"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyRsaTokenKey"/>, <see cref="ContentKeyPolicySymmetricTokenKey"/> and <see cref="ContentKeyPolicyX509CertificateTokenKey"/>.
        /// </param>
        /// <param name="restrictionTokenType"> The type of token. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="issuer"/> or <paramref name="audience"/> is null. </exception>
        public ContentKeyPolicyTokenRestriction(string issuer, string audience, ContentKeyPolicyRestrictionTokenKey primaryVerificationKey, ContentKeyPolicyRestrictionTokenType restrictionTokenType)
        {
            Argument.AssertNotNull(issuer, nameof(issuer));
            Argument.AssertNotNull(audience, nameof(audience));

            Issuer = issuer;
            Audience = audience;
            PrimaryVerificationKey = primaryVerificationKey;
            AlternateVerificationKeys = new ChangeTrackingList<ContentKeyPolicyRestrictionTokenKey>();
            RequiredClaims = new ChangeTrackingList<ContentKeyPolicyTokenClaim>();
            RestrictionTokenType = restrictionTokenType;
            OdataType = "#Microsoft.Media.ContentKeyPolicyTokenRestriction";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyTokenRestriction"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="issuer"> The token issuer. </param>
        /// <param name="audience"> The audience for the token. </param>
        /// <param name="primaryVerificationKey">
        /// The primary verification key.
        /// Please note <see cref="ContentKeyPolicyRestrictionTokenKey"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyRsaTokenKey"/>, <see cref="ContentKeyPolicySymmetricTokenKey"/> and <see cref="ContentKeyPolicyX509CertificateTokenKey"/>.
        /// </param>
        /// <param name="alternateVerificationKeys">
        /// A list of alternative verification keys.
        /// Please note <see cref="ContentKeyPolicyRestrictionTokenKey"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyRsaTokenKey"/>, <see cref="ContentKeyPolicySymmetricTokenKey"/> and <see cref="ContentKeyPolicyX509CertificateTokenKey"/>.
        /// </param>
        /// <param name="requiredClaims"> A list of required token claims. </param>
        /// <param name="restrictionTokenType"> The type of token. </param>
        /// <param name="openIdConnectDiscoveryDocument"> The OpenID connect discovery document. </param>
        internal ContentKeyPolicyTokenRestriction(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, string issuer, string audience, ContentKeyPolicyRestrictionTokenKey primaryVerificationKey, IList<ContentKeyPolicyRestrictionTokenKey> alternateVerificationKeys, IList<ContentKeyPolicyTokenClaim> requiredClaims, ContentKeyPolicyRestrictionTokenType restrictionTokenType, string openIdConnectDiscoveryDocument) : base(odataType, serializedAdditionalRawData)
        {
            Issuer = issuer;
            Audience = audience;
            PrimaryVerificationKey = primaryVerificationKey;
            AlternateVerificationKeys = alternateVerificationKeys;
            RequiredClaims = requiredClaims;
            RestrictionTokenType = restrictionTokenType;
            OpenIdConnectDiscoveryDocument = openIdConnectDiscoveryDocument;
            OdataType = odataType ?? "#Microsoft.Media.ContentKeyPolicyTokenRestriction";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyTokenRestriction"/> for deserialization. </summary>
        internal ContentKeyPolicyTokenRestriction()
        {
        }

        /// <summary> The token issuer. </summary>
        public string Issuer { get; set; }
        /// <summary> The audience for the token. </summary>
        public string Audience { get; set; }
        /// <summary>
        /// The primary verification key.
        /// Please note <see cref="ContentKeyPolicyRestrictionTokenKey"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyRsaTokenKey"/>, <see cref="ContentKeyPolicySymmetricTokenKey"/> and <see cref="ContentKeyPolicyX509CertificateTokenKey"/>.
        /// </summary>
        public ContentKeyPolicyRestrictionTokenKey PrimaryVerificationKey { get; set; }
        /// <summary>
        /// A list of alternative verification keys.
        /// Please note <see cref="ContentKeyPolicyRestrictionTokenKey"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyRsaTokenKey"/>, <see cref="ContentKeyPolicySymmetricTokenKey"/> and <see cref="ContentKeyPolicyX509CertificateTokenKey"/>.
        /// </summary>
        public IList<ContentKeyPolicyRestrictionTokenKey> AlternateVerificationKeys { get; }
        /// <summary> A list of required token claims. </summary>
        public IList<ContentKeyPolicyTokenClaim> RequiredClaims { get; }
        /// <summary> The type of token. </summary>
        public ContentKeyPolicyRestrictionTokenType RestrictionTokenType { get; set; }
        /// <summary> The OpenID connect discovery document. </summary>
        public string OpenIdConnectDiscoveryDocument { get; set; }
    }
}
