// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Represents a token claim. </summary>
    public partial class ContentKeyPolicyTokenClaim
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyTokenClaim"/>. </summary>
        public ContentKeyPolicyTokenClaim()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyTokenClaim"/>. </summary>
        /// <param name="claimType"> Token claim type. </param>
        /// <param name="claimValue"> Token claim value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContentKeyPolicyTokenClaim(string claimType, string claimValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClaimType = claimType;
            ClaimValue = claimValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Token claim type. </summary>
        public string ClaimType { get; set; }
        /// <summary> Token claim value. </summary>
        public string ClaimValue { get; set; }
    }
}
