// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Specifies a symmetric key for token validation. </summary>
    public partial class ContentKeyPolicySymmetricTokenKey : ContentKeyPolicyRestrictionTokenKey
    {
        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicySymmetricTokenKey"/>. </summary>
        /// <param name="keyValue"> The key value of the key. </param>
        public ContentKeyPolicySymmetricTokenKey(byte[] keyValue)
        {
            KeyValue = keyValue;
            OdataType = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicySymmetricTokenKey"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="keyValue"> The key value of the key. </param>
        internal ContentKeyPolicySymmetricTokenKey(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, byte[] keyValue) : base(odataType, serializedAdditionalRawData)
        {
            KeyValue = keyValue;
            OdataType = odataType ?? "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicySymmetricTokenKey"/> for deserialization. </summary>
        internal ContentKeyPolicySymmetricTokenKey()
        {
        }

        /// <summary> The key value of the key. </summary>
        public byte[] KeyValue { get; set; }
    }
}
