// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class ContentKeyPolicySymmetricTokenKey : IUtf8JsonSerializable, IJsonModel<ContentKeyPolicySymmetricTokenKey>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContentKeyPolicySymmetricTokenKey>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContentKeyPolicySymmetricTokenKey>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicySymmetricTokenKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicySymmetricTokenKey)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (KeyValue != null)
            {
                writer.WritePropertyName("keyValue"u8);
                writer.WriteBase64StringValue(KeyValue, "D");
            }
            else
            {
                writer.WriteNull("keyValue");
            }
        }

        ContentKeyPolicySymmetricTokenKey IJsonModel<ContentKeyPolicySymmetricTokenKey>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicySymmetricTokenKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicySymmetricTokenKey)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContentKeyPolicySymmetricTokenKey(document.RootElement, options);
        }

        internal static ContentKeyPolicySymmetricTokenKey DeserializeContentKeyPolicySymmetricTokenKey(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            byte[] keyValue = default;
            string odataType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("keyValue"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        keyValue = null;
                        continue;
                    }
                    keyValue = property.Value.GetBytesFromBase64("D");
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContentKeyPolicySymmetricTokenKey(odataType, serializedAdditionalRawData, keyValue);
        }

        BinaryData IPersistableModel<ContentKeyPolicySymmetricTokenKey>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicySymmetricTokenKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicySymmetricTokenKey)} does not support writing '{options.Format}' format.");
            }
        }

        ContentKeyPolicySymmetricTokenKey IPersistableModel<ContentKeyPolicySymmetricTokenKey>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicySymmetricTokenKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContentKeyPolicySymmetricTokenKey(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicySymmetricTokenKey)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContentKeyPolicySymmetricTokenKey>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
