// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Specifies a RSA key for token validation. </summary>
    public partial class ContentKeyPolicyRsaTokenKey : ContentKeyPolicyRestrictionTokenKey
    {
        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyRsaTokenKey"/>. </summary>
        /// <param name="exponent"> The RSA Parameter exponent. </param>
        /// <param name="modulus"> The RSA Parameter modulus. </param>
        public ContentKeyPolicyRsaTokenKey(byte[] exponent, byte[] modulus)
        {
            Exponent = exponent;
            Modulus = modulus;
            OdataType = "#Microsoft.Media.ContentKeyPolicyRsaTokenKey";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyRsaTokenKey"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="exponent"> The RSA Parameter exponent. </param>
        /// <param name="modulus"> The RSA Parameter modulus. </param>
        internal ContentKeyPolicyRsaTokenKey(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, byte[] exponent, byte[] modulus) : base(odataType, serializedAdditionalRawData)
        {
            Exponent = exponent;
            Modulus = modulus;
            OdataType = odataType ?? "#Microsoft.Media.ContentKeyPolicyRsaTokenKey";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyRsaTokenKey"/> for deserialization. </summary>
        internal ContentKeyPolicyRsaTokenKey()
        {
        }

        /// <summary> The RSA Parameter exponent. </summary>
        public byte[] Exponent { get; set; }
        /// <summary> The RSA Parameter modulus. </summary>
        public byte[] Modulus { get; set; }
    }
}
