// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class ContentKeyPolicyRsaTokenKey : IUtf8JsonSerializable, IJsonModel<ContentKeyPolicyRsaTokenKey>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContentKeyPolicyRsaTokenKey>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContentKeyPolicyRsaTokenKey>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyRsaTokenKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyRsaTokenKey)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Exponent != null)
            {
                writer.WritePropertyName("exponent"u8);
                writer.WriteBase64StringValue(Exponent, "D");
            }
            else
            {
                writer.WriteNull("exponent");
            }
            if (Modulus != null)
            {
                writer.WritePropertyName("modulus"u8);
                writer.WriteBase64StringValue(Modulus, "D");
            }
            else
            {
                writer.WriteNull("modulus");
            }
        }

        ContentKeyPolicyRsaTokenKey IJsonModel<ContentKeyPolicyRsaTokenKey>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyRsaTokenKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyRsaTokenKey)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContentKeyPolicyRsaTokenKey(document.RootElement, options);
        }

        internal static ContentKeyPolicyRsaTokenKey DeserializeContentKeyPolicyRsaTokenKey(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            byte[] exponent = default;
            byte[] modulus = default;
            string odataType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("exponent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        exponent = null;
                        continue;
                    }
                    exponent = property.Value.GetBytesFromBase64("D");
                    continue;
                }
                if (property.NameEquals("modulus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        modulus = null;
                        continue;
                    }
                    modulus = property.Value.GetBytesFromBase64("D");
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContentKeyPolicyRsaTokenKey(odataType, serializedAdditionalRawData, exponent, modulus);
        }

        BinaryData IPersistableModel<ContentKeyPolicyRsaTokenKey>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyRsaTokenKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyRsaTokenKey)} does not support writing '{options.Format}' format.");
            }
        }

        ContentKeyPolicyRsaTokenKey IPersistableModel<ContentKeyPolicyRsaTokenKey>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyRsaTokenKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContentKeyPolicyRsaTokenKey(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyRsaTokenKey)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContentKeyPolicyRsaTokenKey>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
