// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Configures the Play Right in the PlayReady license. </summary>
    public partial class ContentKeyPolicyPlayReadyPlayRight
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyPlayRight"/>. </summary>
        /// <param name="hasDigitalVideoOnlyContentRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="hasImageConstraintForAnalogComponentVideoRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="hasImageConstraintForAnalogComputerMonitorRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="allowPassingVideoContentToUnknownOutput"> Configures Unknown output handling settings of the license. </param>
        public ContentKeyPolicyPlayReadyPlayRight(bool hasDigitalVideoOnlyContentRestriction, bool hasImageConstraintForAnalogComponentVideoRestriction, bool hasImageConstraintForAnalogComputerMonitorRestriction, ContentKeyPolicyPlayReadyUnknownOutputPassingOption allowPassingVideoContentToUnknownOutput)
        {
            HasDigitalVideoOnlyContentRestriction = hasDigitalVideoOnlyContentRestriction;
            HasImageConstraintForAnalogComponentVideoRestriction = hasImageConstraintForAnalogComponentVideoRestriction;
            HasImageConstraintForAnalogComputerMonitorRestriction = hasImageConstraintForAnalogComputerMonitorRestriction;
            AllowPassingVideoContentToUnknownOutput = allowPassingVideoContentToUnknownOutput;
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyPlayRight"/>. </summary>
        /// <param name="firstPlayExpiration"> The amount of time that the license is valid after the license is first used to play content. </param>
        /// <param name="scmsRestriction"> Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive. </param>
        /// <param name="agcAndColorStripeRestriction"> Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive. </param>
        /// <param name="explicitAnalogTelevisionOutputRestriction"> Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive. </param>
        /// <param name="hasDigitalVideoOnlyContentRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="hasImageConstraintForAnalogComponentVideoRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="hasImageConstraintForAnalogComputerMonitorRestriction"> Enables the Image Constraint For Analog Component Video Restriction in the license. </param>
        /// <param name="allowPassingVideoContentToUnknownOutput"> Configures Unknown output handling settings of the license. </param>
        /// <param name="uncompressedDigitalVideoOutputProtectionLevel"> Specifies the output protection level for uncompressed digital video. </param>
        /// <param name="compressedDigitalVideoOutputProtectionLevel"> Specifies the output protection level for compressed digital video. </param>
        /// <param name="analogVideoOutputProtectionLevel"> Specifies the output protection level for compressed digital audio. </param>
        /// <param name="compressedDigitalAudioOutputProtectionLevel"> Specifies the output protection level for compressed digital audio. </param>
        /// <param name="uncompressedDigitalAudioOutputProtectionLevel"> Specifies the output protection level for uncompressed digital audio. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContentKeyPolicyPlayReadyPlayRight(TimeSpan? firstPlayExpiration, int? scmsRestriction, int? agcAndColorStripeRestriction, ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction explicitAnalogTelevisionOutputRestriction, bool hasDigitalVideoOnlyContentRestriction, bool hasImageConstraintForAnalogComponentVideoRestriction, bool hasImageConstraintForAnalogComputerMonitorRestriction, ContentKeyPolicyPlayReadyUnknownOutputPassingOption allowPassingVideoContentToUnknownOutput, int? uncompressedDigitalVideoOutputProtectionLevel, int? compressedDigitalVideoOutputProtectionLevel, int? analogVideoOutputProtectionLevel, int? compressedDigitalAudioOutputProtectionLevel, int? uncompressedDigitalAudioOutputProtectionLevel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstPlayExpiration = firstPlayExpiration;
            ScmsRestriction = scmsRestriction;
            AgcAndColorStripeRestriction = agcAndColorStripeRestriction;
            ExplicitAnalogTelevisionOutputRestriction = explicitAnalogTelevisionOutputRestriction;
            HasDigitalVideoOnlyContentRestriction = hasDigitalVideoOnlyContentRestriction;
            HasImageConstraintForAnalogComponentVideoRestriction = hasImageConstraintForAnalogComponentVideoRestriction;
            HasImageConstraintForAnalogComputerMonitorRestriction = hasImageConstraintForAnalogComputerMonitorRestriction;
            AllowPassingVideoContentToUnknownOutput = allowPassingVideoContentToUnknownOutput;
            UncompressedDigitalVideoOutputProtectionLevel = uncompressedDigitalVideoOutputProtectionLevel;
            CompressedDigitalVideoOutputProtectionLevel = compressedDigitalVideoOutputProtectionLevel;
            AnalogVideoOutputProtectionLevel = analogVideoOutputProtectionLevel;
            CompressedDigitalAudioOutputProtectionLevel = compressedDigitalAudioOutputProtectionLevel;
            UncompressedDigitalAudioOutputProtectionLevel = uncompressedDigitalAudioOutputProtectionLevel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyPlayRight"/> for deserialization. </summary>
        internal ContentKeyPolicyPlayReadyPlayRight()
        {
        }

        /// <summary> The amount of time that the license is valid after the license is first used to play content. </summary>
        public TimeSpan? FirstPlayExpiration { get; set; }
        /// <summary> Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive. </summary>
        public int? ScmsRestriction { get; set; }
        /// <summary> Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive. </summary>
        public int? AgcAndColorStripeRestriction { get; set; }
        /// <summary> Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive. </summary>
        public ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction ExplicitAnalogTelevisionOutputRestriction { get; set; }
        /// <summary> Enables the Image Constraint For Analog Component Video Restriction in the license. </summary>
        public bool HasDigitalVideoOnlyContentRestriction { get; set; }
        /// <summary> Enables the Image Constraint For Analog Component Video Restriction in the license. </summary>
        public bool HasImageConstraintForAnalogComponentVideoRestriction { get; set; }
        /// <summary> Enables the Image Constraint For Analog Component Video Restriction in the license. </summary>
        public bool HasImageConstraintForAnalogComputerMonitorRestriction { get; set; }
        /// <summary> Configures Unknown output handling settings of the license. </summary>
        public ContentKeyPolicyPlayReadyUnknownOutputPassingOption AllowPassingVideoContentToUnknownOutput { get; set; }
        /// <summary> Specifies the output protection level for uncompressed digital video. </summary>
        public int? UncompressedDigitalVideoOutputProtectionLevel { get; set; }
        /// <summary> Specifies the output protection level for compressed digital video. </summary>
        public int? CompressedDigitalVideoOutputProtectionLevel { get; set; }
        /// <summary> Specifies the output protection level for compressed digital audio. </summary>
        public int? AnalogVideoOutputProtectionLevel { get; set; }
        /// <summary> Specifies the output protection level for compressed digital audio. </summary>
        public int? CompressedDigitalAudioOutputProtectionLevel { get; set; }
        /// <summary> Specifies the output protection level for uncompressed digital audio. </summary>
        public int? UncompressedDigitalAudioOutputProtectionLevel { get; set; }
    }
}
