// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The license type. </summary>
    public readonly partial struct ContentKeyPolicyPlayReadyLicenseType : IEquatable<ContentKeyPolicyPlayReadyLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContentKeyPolicyPlayReadyLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string NonPersistentValue = "NonPersistent";
        private const string PersistentValue = "Persistent";

        /// <summary> Represents a ContentKeyPolicyPlayReadyLicenseType that is unavailable in current API version. </summary>
        public static ContentKeyPolicyPlayReadyLicenseType Unknown { get; } = new ContentKeyPolicyPlayReadyLicenseType(UnknownValue);
        /// <summary> Non persistent license. </summary>
        public static ContentKeyPolicyPlayReadyLicenseType NonPersistent { get; } = new ContentKeyPolicyPlayReadyLicenseType(NonPersistentValue);
        /// <summary> Persistent license. Allows offline playback. </summary>
        public static ContentKeyPolicyPlayReadyLicenseType Persistent { get; } = new ContentKeyPolicyPlayReadyLicenseType(PersistentValue);
        /// <summary> Determines if two <see cref="ContentKeyPolicyPlayReadyLicenseType"/> values are the same. </summary>
        public static bool operator ==(ContentKeyPolicyPlayReadyLicenseType left, ContentKeyPolicyPlayReadyLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContentKeyPolicyPlayReadyLicenseType"/> values are not the same. </summary>
        public static bool operator !=(ContentKeyPolicyPlayReadyLicenseType left, ContentKeyPolicyPlayReadyLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContentKeyPolicyPlayReadyLicenseType"/>. </summary>
        public static implicit operator ContentKeyPolicyPlayReadyLicenseType(string value) => new ContentKeyPolicyPlayReadyLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContentKeyPolicyPlayReadyLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContentKeyPolicyPlayReadyLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
