// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction : IUtf8JsonSerializable, IJsonModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("bestEffort"u8);
            writer.WriteBooleanValue(IsBestEffort);
            writer.WritePropertyName("configurationData"u8);
            writer.WriteNumberValue(ConfigurationData);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction IJsonModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(document.RootElement, options);
        }

        internal static ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction DeserializeContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool bestEffort = default;
            int configurationData = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bestEffort"u8))
                {
                    bestEffort = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("configurationData"u8))
                {
                    configurationData = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(bestEffort, configurationData, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction)} does not support writing '{options.Format}' format.");
            }
        }

        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
