// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The PlayReady content type. </summary>
    public readonly partial struct ContentKeyPolicyPlayReadyContentType : IEquatable<ContentKeyPolicyPlayReadyContentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyContentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContentKeyPolicyPlayReadyContentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string UnspecifiedValue = "Unspecified";
        private const string UltraVioletDownloadValue = "UltraVioletDownload";
        private const string UltraVioletStreamingValue = "UltraVioletStreaming";

        /// <summary> Represents a ContentKeyPolicyPlayReadyContentType that is unavailable in current API version. </summary>
        public static ContentKeyPolicyPlayReadyContentType Unknown { get; } = new ContentKeyPolicyPlayReadyContentType(UnknownValue);
        /// <summary> Unspecified content type. </summary>
        public static ContentKeyPolicyPlayReadyContentType Unspecified { get; } = new ContentKeyPolicyPlayReadyContentType(UnspecifiedValue);
        /// <summary> Ultraviolet download content type. </summary>
        public static ContentKeyPolicyPlayReadyContentType UltraVioletDownload { get; } = new ContentKeyPolicyPlayReadyContentType(UltraVioletDownloadValue);
        /// <summary> Ultraviolet streaming content type. </summary>
        public static ContentKeyPolicyPlayReadyContentType UltraVioletStreaming { get; } = new ContentKeyPolicyPlayReadyContentType(UltraVioletStreamingValue);
        /// <summary> Determines if two <see cref="ContentKeyPolicyPlayReadyContentType"/> values are the same. </summary>
        public static bool operator ==(ContentKeyPolicyPlayReadyContentType left, ContentKeyPolicyPlayReadyContentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContentKeyPolicyPlayReadyContentType"/> values are not the same. </summary>
        public static bool operator !=(ContentKeyPolicyPlayReadyContentType left, ContentKeyPolicyPlayReadyContentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContentKeyPolicyPlayReadyContentType"/>. </summary>
        public static implicit operator ContentKeyPolicyPlayReadyContentType(string value) => new ContentKeyPolicyPlayReadyContentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContentKeyPolicyPlayReadyContentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContentKeyPolicyPlayReadyContentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
