// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Specifies that the content key ID is specified in the PlayReady configuration. </summary>
    public partial class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier : ContentKeyPolicyPlayReadyContentKeyLocation
    {
        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier"/>. </summary>
        /// <param name="keyId"> The content key ID. </param>
        public ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier(Guid? keyId)
        {
            KeyId = keyId;
            OdataType = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="keyId"> The content key ID. </param>
        internal ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, Guid? keyId) : base(odataType, serializedAdditionalRawData)
        {
            KeyId = keyId;
            OdataType = odataType ?? "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier";
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier"/> for deserialization. </summary>
        internal ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier()
        {
        }

        /// <summary> The content key ID. </summary>
        public Guid? KeyId { get; set; }
    }
}
