// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    public partial class ContentKeyPolicyFairPlayConfiguration : IUtf8JsonSerializable, IJsonModel<ContentKeyPolicyFairPlayConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContentKeyPolicyFairPlayConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContentKeyPolicyFairPlayConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyFairPlayConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyFairPlayConfiguration)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (ApplicationSecretKey != null)
            {
                writer.WritePropertyName("ask"u8);
                writer.WriteBase64StringValue(ApplicationSecretKey, "D");
            }
            else
            {
                writer.WriteNull("ask");
            }
            if (FairPlayPfxPassword != null)
            {
                writer.WritePropertyName("fairPlayPfxPassword"u8);
                writer.WriteStringValue(FairPlayPfxPassword);
            }
            else
            {
                writer.WriteNull("fairPlayPfxPassword");
            }
            if (FairPlayPfx != null)
            {
                writer.WritePropertyName("fairPlayPfx"u8);
                writer.WriteStringValue(FairPlayPfx);
            }
            else
            {
                writer.WriteNull("fairPlayPfx");
            }
            writer.WritePropertyName("rentalAndLeaseKeyType"u8);
            writer.WriteStringValue(RentalAndLeaseKeyType.ToString());
            writer.WritePropertyName("rentalDuration"u8);
            writer.WriteNumberValue(RentalDuration);
            if (Optional.IsDefined(OfflineRentalConfiguration))
            {
                writer.WritePropertyName("offlineRentalConfiguration"u8);
                writer.WriteObjectValue(OfflineRentalConfiguration, options);
            }
        }

        ContentKeyPolicyFairPlayConfiguration IJsonModel<ContentKeyPolicyFairPlayConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyFairPlayConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContentKeyPolicyFairPlayConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContentKeyPolicyFairPlayConfiguration(document.RootElement, options);
        }

        internal static ContentKeyPolicyFairPlayConfiguration DeserializeContentKeyPolicyFairPlayConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            byte[] ask = default;
            string fairPlayPfxPassword = default;
            string fairPlayPfx = default;
            ContentKeyPolicyFairPlayRentalAndLeaseKeyType rentalAndLeaseKeyType = default;
            long rentalDuration = default;
            ContentKeyPolicyFairPlayOfflineRentalConfiguration offlineRentalConfiguration = default;
            string odataType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        ask = null;
                        continue;
                    }
                    ask = property.Value.GetBytesFromBase64("D");
                    continue;
                }
                if (property.NameEquals("fairPlayPfxPassword"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        fairPlayPfxPassword = null;
                        continue;
                    }
                    fairPlayPfxPassword = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fairPlayPfx"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        fairPlayPfx = null;
                        continue;
                    }
                    fairPlayPfx = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rentalAndLeaseKeyType"u8))
                {
                    rentalAndLeaseKeyType = new ContentKeyPolicyFairPlayRentalAndLeaseKeyType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("rentalDuration"u8))
                {
                    rentalDuration = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("offlineRentalConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    offlineRentalConfiguration = ContentKeyPolicyFairPlayOfflineRentalConfiguration.DeserializeContentKeyPolicyFairPlayOfflineRentalConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("@odata.type"u8))
                {
                    odataType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContentKeyPolicyFairPlayConfiguration(
                odataType,
                serializedAdditionalRawData,
                ask,
                fairPlayPfxPassword,
                fairPlayPfx,
                rentalAndLeaseKeyType,
                rentalDuration,
                offlineRentalConfiguration);
        }

        BinaryData IPersistableModel<ContentKeyPolicyFairPlayConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyFairPlayConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyFairPlayConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        ContentKeyPolicyFairPlayConfiguration IPersistableModel<ContentKeyPolicyFairPlayConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContentKeyPolicyFairPlayConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContentKeyPolicyFairPlayConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContentKeyPolicyFairPlayConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContentKeyPolicyFairPlayConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
