// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks. </summary>
    public readonly partial struct ChannelMapping : IEquatable<ChannelMapping>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChannelMapping"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChannelMapping(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FrontLeftValue = "FrontLeft";
        private const string FrontRightValue = "FrontRight";
        private const string CenterValue = "Center";
        private const string LowFrequencyEffectsValue = "LowFrequencyEffects";
        private const string BackLeftValue = "BackLeft";
        private const string BackRightValue = "BackRight";
        private const string StereoLeftValue = "StereoLeft";
        private const string StereoRightValue = "StereoRight";

        /// <summary> The Front Left Channel. </summary>
        public static ChannelMapping FrontLeft { get; } = new ChannelMapping(FrontLeftValue);
        /// <summary> The Front Right Channel. </summary>
        public static ChannelMapping FrontRight { get; } = new ChannelMapping(FrontRightValue);
        /// <summary> The Center Channel. </summary>
        public static ChannelMapping Center { get; } = new ChannelMapping(CenterValue);
        /// <summary> Low Frequency Effects Channel.  Sometimes referred to as the subwoofer. </summary>
        public static ChannelMapping LowFrequencyEffects { get; } = new ChannelMapping(LowFrequencyEffectsValue);
        /// <summary> The Back Left Channel.  Sometimes referred to as the Left Surround Channel. </summary>
        public static ChannelMapping BackLeft { get; } = new ChannelMapping(BackLeftValue);
        /// <summary> The Back Right Channel.  Sometimes referred to as the Right Surround Channel. </summary>
        public static ChannelMapping BackRight { get; } = new ChannelMapping(BackRightValue);
        /// <summary> The Left Stereo channel.  Sometimes referred to as Down Mix Left. </summary>
        public static ChannelMapping StereoLeft { get; } = new ChannelMapping(StereoLeftValue);
        /// <summary> The Right Stereo channel.  Sometimes referred to as Down Mix Right. </summary>
        public static ChannelMapping StereoRight { get; } = new ChannelMapping(StereoRightValue);
        /// <summary> Determines if two <see cref="ChannelMapping"/> values are the same. </summary>
        public static bool operator ==(ChannelMapping left, ChannelMapping right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChannelMapping"/> values are not the same. </summary>
        public static bool operator !=(ChannelMapping left, ChannelMapping right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChannelMapping"/>. </summary>
        public static implicit operator ChannelMapping(string value) => new ChannelMapping(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChannelMapping other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChannelMapping other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
