// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Describes a built-in preset for encoding the input video with the Standard Encoder. </summary>
    public partial class BuiltInStandardEncoderPreset : MediaTransformPreset
    {
        /// <summary> Initializes a new instance of <see cref="BuiltInStandardEncoderPreset"/>. </summary>
        /// <param name="presetName"> The built-in preset to be used for encoding videos. </param>
        public BuiltInStandardEncoderPreset(EncoderNamedPreset presetName)
        {
            PresetName = presetName;
            OdataType = "#Microsoft.Media.BuiltInStandardEncoderPreset";
        }

        /// <summary> Initializes a new instance of <see cref="BuiltInStandardEncoderPreset"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="configurations"> Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset. </param>
        /// <param name="presetName"> The built-in preset to be used for encoding videos. </param>
        internal BuiltInStandardEncoderPreset(string odataType, IDictionary<string, BinaryData> serializedAdditionalRawData, EncoderPresetConfigurations configurations, EncoderNamedPreset presetName) : base(odataType, serializedAdditionalRawData)
        {
            Configurations = configurations;
            PresetName = presetName;
            OdataType = odataType ?? "#Microsoft.Media.BuiltInStandardEncoderPreset";
        }

        /// <summary> Initializes a new instance of <see cref="BuiltInStandardEncoderPreset"/> for deserialization. </summary>
        internal BuiltInStandardEncoderPreset()
        {
        }

        /// <summary> Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset. </summary>
        public EncoderPresetConfigurations Configurations { get; set; }
        /// <summary> The built-in preset to be used for encoding videos. </summary>
        public EncoderNamedPreset PresetName { get; set; }
    }
}
