// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen. </summary>
    public readonly partial struct AudioAnalysisMode : IEquatable<AudioAnalysisMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AudioAnalysisMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AudioAnalysisMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string BasicValue = "Basic";

        /// <summary> Performs all operations included in the Basic mode, additionally performing language detection and speaker diarization. </summary>
        public static AudioAnalysisMode Standard { get; } = new AudioAnalysisMode(StandardValue);
        /// <summary> This mode performs speech-to-text transcription and generation of a VTT subtitle/caption file. The output of this mode includes an Insights JSON file including only the keywords, transcription,and timing information. Automatic language detection and speaker diarization are not included in this mode. </summary>
        public static AudioAnalysisMode Basic { get; } = new AudioAnalysisMode(BasicValue);
        /// <summary> Determines if two <see cref="AudioAnalysisMode"/> values are the same. </summary>
        public static bool operator ==(AudioAnalysisMode left, AudioAnalysisMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AudioAnalysisMode"/> values are not the same. </summary>
        public static bool operator !=(AudioAnalysisMode left, AudioAnalysisMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AudioAnalysisMode"/>. </summary>
        public static implicit operator AudioAnalysisMode(string value) => new AudioAnalysisMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AudioAnalysisMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AudioAnalysisMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
