// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The Asset Storage container SAS URLs. </summary>
    internal partial class AssetContainerSas
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssetContainerSas"/>. </summary>
        internal AssetContainerSas()
        {
            AssetContainerSasUris = new ChangeTrackingList<Uri>();
        }

        /// <summary> Initializes a new instance of <see cref="AssetContainerSas"/>. </summary>
        /// <param name="assetContainerSasUris"> The list of Asset container SAS URLs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssetContainerSas(IReadOnlyList<Uri> assetContainerSasUris, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AssetContainerSasUris = assetContainerSasUris;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of Asset container SAS URLs. </summary>
        public IReadOnlyList<Uri> AssetContainerSasUris { get; }
    }
}
