// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Media.Models
{
    internal partial class AkamaiAccessControl : IUtf8JsonSerializable, IJsonModel<AkamaiAccessControl>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AkamaiAccessControl>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AkamaiAccessControl>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AkamaiAccessControl>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AkamaiAccessControl)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(AkamaiSignatureHeaderAuthenticationKeyList))
            {
                writer.WritePropertyName("akamaiSignatureHeaderAuthenticationKeyList"u8);
                writer.WriteStartArray();
                foreach (var item in AkamaiSignatureHeaderAuthenticationKeyList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AkamaiAccessControl IJsonModel<AkamaiAccessControl>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AkamaiAccessControl>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AkamaiAccessControl)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAkamaiAccessControl(document.RootElement, options);
        }

        internal static AkamaiAccessControl DeserializeAkamaiAccessControl(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<AkamaiSignatureHeaderAuthenticationKey> akamaiSignatureHeaderAuthenticationKeyList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("akamaiSignatureHeaderAuthenticationKeyList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AkamaiSignatureHeaderAuthenticationKey> array = new List<AkamaiSignatureHeaderAuthenticationKey>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AkamaiSignatureHeaderAuthenticationKey.DeserializeAkamaiSignatureHeaderAuthenticationKey(item, options));
                    }
                    akamaiSignatureHeaderAuthenticationKeyList = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AkamaiAccessControl(akamaiSignatureHeaderAuthenticationKeyList ?? new ChangeTrackingList<AkamaiSignatureHeaderAuthenticationKey>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AkamaiAccessControl>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AkamaiAccessControl>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AkamaiAccessControl)} does not support writing '{options.Format}' format.");
            }
        }

        AkamaiAccessControl IPersistableModel<AkamaiAccessControl>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AkamaiAccessControl>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAkamaiAccessControl(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AkamaiAccessControl)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AkamaiAccessControl>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
