// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> The encoding profile to be used when encoding audio with AAC. </summary>
    public readonly partial struct AacAudioProfile : IEquatable<AacAudioProfile>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AacAudioProfile"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AacAudioProfile(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AacLcValue = "AacLc";
        private const string HEAacV1Value = "HeAacV1";
        private const string HEAacV2Value = "HeAacV2";

        /// <summary> Specifies that the output audio is to be encoded into AAC Low Complexity profile (AAC-LC). </summary>
        public static AacAudioProfile AacLc { get; } = new AacAudioProfile(AacLcValue);
        /// <summary> Specifies that the output audio is to be encoded into HE-AAC v1 profile. </summary>
        public static AacAudioProfile HEAacV1 { get; } = new AacAudioProfile(HEAacV1Value);
        /// <summary> Specifies that the output audio is to be encoded into HE-AAC v2 profile. </summary>
        public static AacAudioProfile HEAacV2 { get; } = new AacAudioProfile(HEAacV2Value);
        /// <summary> Determines if two <see cref="AacAudioProfile"/> values are the same. </summary>
        public static bool operator ==(AacAudioProfile left, AacAudioProfile right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AacAudioProfile"/> values are not the same. </summary>
        public static bool operator !=(AacAudioProfile left, AacAudioProfile right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AacAudioProfile"/>. </summary>
        public static implicit operator AacAudioProfile(string value) => new AacAudioProfile(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AacAudioProfile other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AacAudioProfile other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
