// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing a collection of <see cref="MediaTransformResource"/> and their operations.
    /// Each <see cref="MediaTransformResource"/> in the collection will belong to the same instance of <see cref="MediaServicesAccountResource"/>.
    /// To get a <see cref="MediaTransformCollection"/> instance call the GetMediaTransforms method from an instance of <see cref="MediaServicesAccountResource"/>.
    /// </summary>
    public partial class MediaTransformCollection : ArmCollection, IEnumerable<MediaTransformResource>, IAsyncEnumerable<MediaTransformResource>
    {
        private readonly ClientDiagnostics _mediaTransformTransformsClientDiagnostics;
        private readonly TransformsRestOperations _mediaTransformTransformsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MediaTransformCollection"/> class for mocking. </summary>
        protected MediaTransformCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MediaTransformCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MediaTransformCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mediaTransformTransformsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Media", MediaTransformResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MediaTransformResource.ResourceType, out string mediaTransformTransformsApiVersion);
            _mediaTransformTransformsRestClient = new TransformsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mediaTransformTransformsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != MediaServicesAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, MediaServicesAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a new Transform.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="data"> The request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<MediaTransformResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string transformName, MediaTransformData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _mediaTransformTransformsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, data, cancellationToken).ConfigureAwait(false);
                var uri = _mediaTransformTransformsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new MediaArmOperation<MediaTransformResource>(Response.FromValue(new MediaTransformResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a new Transform.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="data"> The request parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<MediaTransformResource> CreateOrUpdate(WaitUntil waitUntil, string transformName, MediaTransformData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _mediaTransformTransformsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, data, cancellationToken);
                var uri = _mediaTransformTransformsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new MediaArmOperation<MediaTransformResource>(Response.FromValue(new MediaTransformResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a Transform.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual async Task<Response<MediaTransformResource>> GetAsync(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.Get");
            scope.Start();
            try
            {
                var response = await _mediaTransformTransformsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MediaTransformResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a Transform.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual Response<MediaTransformResource> Get(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.Get");
            scope.Start();
            try
            {
                var response = _mediaTransformTransformsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MediaTransformResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the Transforms in the account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Restricts the set of items returned. </param>
        /// <param name="orderby"> Specifies the key by which the result collection should be ordered. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MediaTransformResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MediaTransformResource> GetAllAsync(string filter = null, string orderby = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mediaTransformTransformsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderby);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mediaTransformTransformsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderby);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MediaTransformResource(Client, MediaTransformData.DeserializeMediaTransformData(e)), _mediaTransformTransformsClientDiagnostics, Pipeline, "MediaTransformCollection.GetAll", "value", "@odata.nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the Transforms in the account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Restricts the set of items returned. </param>
        /// <param name="orderby"> Specifies the key by which the result collection should be ordered. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MediaTransformResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MediaTransformResource> GetAll(string filter = null, string orderby = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mediaTransformTransformsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderby);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mediaTransformTransformsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderby);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MediaTransformResource(Client, MediaTransformData.DeserializeMediaTransformData(e)), _mediaTransformTransformsClientDiagnostics, Pipeline, "MediaTransformCollection.GetAll", "value", "@odata.nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.Exists");
            scope.Start();
            try
            {
                var response = await _mediaTransformTransformsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual Response<bool> Exists(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.Exists");
            scope.Start();
            try
            {
                var response = _mediaTransformTransformsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual async Task<NullableResponse<MediaTransformResource>> GetIfExistsAsync(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _mediaTransformTransformsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MediaTransformResource>(response.GetRawResponse());
                return Response.FromValue(new MediaTransformResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Transforms_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-07-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaTransformResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transformName"> The Transform name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transformName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transformName"/> is null. </exception>
        public virtual NullableResponse<MediaTransformResource> GetIfExists(string transformName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transformName, nameof(transformName));

            using var scope = _mediaTransformTransformsClientDiagnostics.CreateScope("MediaTransformCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _mediaTransformTransformsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, transformName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MediaTransformResource>(response.GetRawResponse());
                return Response.FromValue(new MediaTransformResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<MediaTransformResource> IEnumerable<MediaTransformResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<MediaTransformResource> IAsyncEnumerable<MediaTransformResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
