// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the MediaServicesAccountFilter data model.
    /// An Account Filter.
    /// </summary>
    public partial class MediaServicesAccountFilterData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaServicesAccountFilterData"/>. </summary>
        public MediaServicesAccountFilterData()
        {
            Tracks = new ChangeTrackingList<FilterTrackSelection>();
        }

        /// <summary> Initializes a new instance of <see cref="MediaServicesAccountFilterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="presentationTimeRange"> The presentation time range. </param>
        /// <param name="firstQuality"> The first quality. </param>
        /// <param name="tracks"> The tracks selection conditions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaServicesAccountFilterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, PresentationTimeRange presentationTimeRange, FirstQuality firstQuality, IList<FilterTrackSelection> tracks, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PresentationTimeRange = presentationTimeRange;
            FirstQuality = firstQuality;
            Tracks = tracks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The presentation time range. </summary>
        public PresentationTimeRange PresentationTimeRange { get; set; }
        /// <summary> The first quality. </summary>
        internal FirstQuality FirstQuality { get; set; }
        /// <summary> The first quality bitrate. </summary>
        public int? FirstQualityBitrate
        {
            get => FirstQuality is null ? default(int?) : FirstQuality.Bitrate;
            set
            {
                FirstQuality = value.HasValue ? new FirstQuality(value.Value) : null;
            }
        }

        /// <summary> The tracks selection conditions. </summary>
        public IList<FilterTrackSelection> Tracks { get; }
    }
}
