// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    public partial class MediaLiveOutputData : IUtf8JsonSerializable, IJsonModel<MediaLiveOutputData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MediaLiveOutputData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MediaLiveOutputData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveOutputData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveOutputData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(AssetName))
            {
                writer.WritePropertyName("assetName"u8);
                writer.WriteStringValue(AssetName);
            }
            if (Optional.IsDefined(ArchiveWindowLength))
            {
                writer.WritePropertyName("archiveWindowLength"u8);
                writer.WriteStringValue(ArchiveWindowLength.Value, "P");
            }
            if (Optional.IsDefined(RewindWindowLength))
            {
                if (RewindWindowLength != null)
                {
                    writer.WritePropertyName("rewindWindowLength"u8);
                    writer.WriteStringValue(RewindWindowLength.Value, "P");
                }
                else
                {
                    writer.WriteNull("rewindWindowLength");
                }
            }
            if (Optional.IsDefined(ManifestName))
            {
                writer.WritePropertyName("manifestName"u8);
                writer.WriteStringValue(ManifestName);
            }
            if (Optional.IsDefined(Hls))
            {
                writer.WritePropertyName("hls"u8);
                writer.WriteObjectValue(Hls, options);
            }
            if (Optional.IsDefined(OutputSnapTime))
            {
                writer.WritePropertyName("outputSnapTime"u8);
                writer.WriteNumberValue(OutputSnapTime.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("created"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastModifiedOn))
            {
                writer.WritePropertyName("lastModified"u8);
                writer.WriteStringValue(LastModifiedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceState))
            {
                writer.WritePropertyName("resourceState"u8);
                writer.WriteStringValue(ResourceState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        MediaLiveOutputData IJsonModel<MediaLiveOutputData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveOutputData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveOutputData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMediaLiveOutputData(document.RootElement, options);
        }

        internal static MediaLiveOutputData DeserializeMediaLiveOutputData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            string assetName = default;
            TimeSpan? archiveWindowLength = default;
            TimeSpan? rewindWindowLength = default;
            string manifestName = default;
            Hls hls = default;
            long? outputSnapTime = default;
            DateTimeOffset? created = default;
            DateTimeOffset? lastModified = default;
            string provisioningState = default;
            LiveOutputResourceState? resourceState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("assetName"u8))
                        {
                            assetName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("archiveWindowLength"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            archiveWindowLength = property0.Value.GetTimeSpan("P");
                            continue;
                        }
                        if (property0.NameEquals("rewindWindowLength"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                rewindWindowLength = null;
                                continue;
                            }
                            rewindWindowLength = property0.Value.GetTimeSpan("P");
                            continue;
                        }
                        if (property0.NameEquals("manifestName"u8))
                        {
                            manifestName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("hls"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hls = Hls.DeserializeHls(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("outputSnapTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            outputSnapTime = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("created"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            created = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastModified"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastModified = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceState = new LiveOutputResourceState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MediaLiveOutputData(
                id,
                name,
                type,
                systemData,
                description,
                assetName,
                archiveWindowLength,
                rewindWindowLength,
                manifestName,
                hls,
                outputSnapTime,
                created,
                lastModified,
                provisioningState,
                resourceState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MediaLiveOutputData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveOutputData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MediaLiveOutputData)} does not support writing '{options.Format}' format.");
            }
        }

        MediaLiveOutputData IPersistableModel<MediaLiveOutputData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveOutputData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMediaLiveOutputData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MediaLiveOutputData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MediaLiveOutputData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
