// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing a collection of <see cref="MediaLiveOutputResource"/> and their operations.
    /// Each <see cref="MediaLiveOutputResource"/> in the collection will belong to the same instance of <see cref="MediaLiveEventResource"/>.
    /// To get a <see cref="MediaLiveOutputCollection"/> instance call the GetMediaLiveOutputs method from an instance of <see cref="MediaLiveEventResource"/>.
    /// </summary>
    public partial class MediaLiveOutputCollection : ArmCollection, IEnumerable<MediaLiveOutputResource>, IAsyncEnumerable<MediaLiveOutputResource>
    {
        private readonly ClientDiagnostics _mediaLiveOutputLiveOutputsClientDiagnostics;
        private readonly LiveOutputsRestOperations _mediaLiveOutputLiveOutputsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MediaLiveOutputCollection"/> class for mocking. </summary>
        protected MediaLiveOutputCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MediaLiveOutputCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal MediaLiveOutputCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _mediaLiveOutputLiveOutputsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Media", MediaLiveOutputResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(MediaLiveOutputResource.ResourceType, out string mediaLiveOutputLiveOutputsApiVersion);
            _mediaLiveOutputLiveOutputsRestClient = new LiveOutputsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, mediaLiveOutputLiveOutputsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != MediaLiveEventResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, MediaLiveEventResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a new live output.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="data"> Live Output properties needed for creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<MediaLiveOutputResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string liveOutputName, MediaLiveOutputData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _mediaLiveOutputLiveOutputsRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, data, cancellationToken).ConfigureAwait(false);
                var operation = new MediaArmOperation<MediaLiveOutputResource>(new MediaLiveOutputOperationSource(Client), _mediaLiveOutputLiveOutputsClientDiagnostics, Pipeline, _mediaLiveOutputLiveOutputsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a new live output.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="data"> Live Output properties needed for creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<MediaLiveOutputResource> CreateOrUpdate(WaitUntil waitUntil, string liveOutputName, MediaLiveOutputData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _mediaLiveOutputLiveOutputsRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, data, cancellationToken);
                var operation = new MediaArmOperation<MediaLiveOutputResource>(new MediaLiveOutputOperationSource(Client), _mediaLiveOutputLiveOutputsClientDiagnostics, Pipeline, _mediaLiveOutputLiveOutputsRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a live output.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual async Task<Response<MediaLiveOutputResource>> GetAsync(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.Get");
            scope.Start();
            try
            {
                var response = await _mediaLiveOutputLiveOutputsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MediaLiveOutputResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a live output.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual Response<MediaLiveOutputResource> Get(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.Get");
            scope.Start();
            try
            {
                var response = _mediaLiveOutputLiveOutputsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new MediaLiveOutputResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the live outputs of a live event.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MediaLiveOutputResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MediaLiveOutputResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mediaLiveOutputLiveOutputsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mediaLiveOutputLiveOutputsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new MediaLiveOutputResource(Client, MediaLiveOutputData.DeserializeMediaLiveOutputData(e)), _mediaLiveOutputLiveOutputsClientDiagnostics, Pipeline, "MediaLiveOutputCollection.GetAll", "value", "@odata.nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the live outputs of a live event.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MediaLiveOutputResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MediaLiveOutputResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _mediaLiveOutputLiveOutputsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _mediaLiveOutputLiveOutputsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new MediaLiveOutputResource(Client, MediaLiveOutputData.DeserializeMediaLiveOutputData(e)), _mediaLiveOutputLiveOutputsClientDiagnostics, Pipeline, "MediaLiveOutputCollection.GetAll", "value", "@odata.nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.Exists");
            scope.Start();
            try
            {
                var response = await _mediaLiveOutputLiveOutputsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual Response<bool> Exists(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.Exists");
            scope.Start();
            try
            {
                var response = _mediaLiveOutputLiveOutputsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual async Task<NullableResponse<MediaLiveOutputResource>> GetIfExistsAsync(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _mediaLiveOutputLiveOutputsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<MediaLiveOutputResource>(response.GetRawResponse());
                return Response.FromValue(new MediaLiveOutputResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LiveOutputs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="MediaLiveOutputResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="liveOutputName"> The name of the live output. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="liveOutputName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="liveOutputName"/> is null. </exception>
        public virtual NullableResponse<MediaLiveOutputResource> GetIfExists(string liveOutputName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(liveOutputName, nameof(liveOutputName));

            using var scope = _mediaLiveOutputLiveOutputsClientDiagnostics.CreateScope("MediaLiveOutputCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _mediaLiveOutputLiveOutputsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, liveOutputName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<MediaLiveOutputResource>(response.GetRawResponse());
                return Response.FromValue(new MediaLiveOutputResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<MediaLiveOutputResource> IEnumerable<MediaLiveOutputResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<MediaLiveOutputResource> IAsyncEnumerable<MediaLiveOutputResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
