// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the MediaJob data model.
    /// A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
    /// </summary>
    public partial class MediaJobData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaJobData"/>. </summary>
        public MediaJobData()
        {
            Outputs = new ChangeTrackingList<MediaJobOutput>();
            CorrelationData = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MediaJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="state"> The current state of the job. </param>
        /// <param name="description"> Optional customer supplied description of the Job. </param>
        /// <param name="input">
        /// The inputs for the Job.
        /// Please note <see cref="MediaJobInputBasicProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobInputAsset"/>, <see cref="MediaJobInputClip"/>, <see cref="MediaJobInputHttp"/>, <see cref="MediaJobInputs"/> and <see cref="MediaJobInputSequence"/>.
        /// </param>
        /// <param name="lastModifiedOn"> The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="outputs">
        /// The outputs for the Job.
        /// Please note <see cref="MediaJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobOutputAsset"/>.
        /// </param>
        /// <param name="priority"> Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal. </param>
        /// <param name="correlationData"> Customer provided key, value pairs that will be returned in Job and JobOutput state events. </param>
        /// <param name="startOn"> The UTC date and time at which this Job began processing. </param>
        /// <param name="endOn"> The UTC date and time at which this Job finished processing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaJobData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? createdOn, MediaJobState? state, string description, MediaJobInputBasicProperties input, DateTimeOffset? lastModifiedOn, IList<MediaJobOutput> outputs, MediaJobPriority? priority, IDictionary<string, string> correlationData, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CreatedOn = createdOn;
            State = state;
            Description = description;
            Input = input;
            LastModifiedOn = lastModifiedOn;
            Outputs = outputs;
            Priority = priority;
            CorrelationData = correlationData;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The current state of the job. </summary>
        public MediaJobState? State { get; }
        /// <summary> Optional customer supplied description of the Job. </summary>
        public string Description { get; set; }
        /// <summary>
        /// The inputs for the Job.
        /// Please note <see cref="MediaJobInputBasicProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobInputAsset"/>, <see cref="MediaJobInputClip"/>, <see cref="MediaJobInputHttp"/>, <see cref="MediaJobInputs"/> and <see cref="MediaJobInputSequence"/>.
        /// </summary>
        public MediaJobInputBasicProperties Input { get; set; }
        /// <summary> The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary>
        /// The outputs for the Job.
        /// Please note <see cref="MediaJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobOutputAsset"/>.
        /// </summary>
        public IList<MediaJobOutput> Outputs { get; }
        /// <summary> Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal. </summary>
        public MediaJobPriority? Priority { get; set; }
        /// <summary> Customer provided key, value pairs that will be returned in Job and JobOutput state events. </summary>
        public IDictionary<string, string> CorrelationData { get; }
        /// <summary> The UTC date and time at which this Job began processing. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The UTC date and time at which this Job finished processing. </summary>
        public DateTimeOffset? EndOn { get; }
    }
}
