// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Media
{
    internal class MediaLiveOutputOperationSource : IOperationSource<MediaLiveOutputResource>
    {
        private readonly ArmClient _client;

        internal MediaLiveOutputOperationSource(ArmClient client)
        {
            _client = client;
        }

        MediaLiveOutputResource IOperationSource<MediaLiveOutputResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MediaLiveOutputData.DeserializeMediaLiveOutputData(document.RootElement);
            return new MediaLiveOutputResource(_client, data);
        }

        async ValueTask<MediaLiveOutputResource> IOperationSource<MediaLiveOutputResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MediaLiveOutputData.DeserializeMediaLiveOutputData(document.RootElement);
            return new MediaLiveOutputResource(_client, data);
        }
    }
}
