// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Media
{
    internal class MediaLiveEventOperationSource : IOperationSource<MediaLiveEventResource>
    {
        private readonly ArmClient _client;

        internal MediaLiveEventOperationSource(ArmClient client)
        {
            _client = client;
        }

        MediaLiveEventResource IOperationSource<MediaLiveEventResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MediaLiveEventData.DeserializeMediaLiveEventData(document.RootElement);
            return new MediaLiveEventResource(_client, data);
        }

        async ValueTask<MediaLiveEventResource> IOperationSource<MediaLiveEventResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MediaLiveEventData.DeserializeMediaLiveEventData(document.RootElement);
            return new MediaLiveEventResource(_client, data);
        }
    }
}
