// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Media
{
    internal class MediaAssetTrackOperationSource : IOperationSource<MediaAssetTrackResource>
    {
        private readonly ArmClient _client;

        internal MediaAssetTrackOperationSource(ArmClient client)
        {
            _client = client;
        }

        MediaAssetTrackResource IOperationSource<MediaAssetTrackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MediaAssetTrackData.DeserializeMediaAssetTrackData(document.RootElement);
            return new MediaAssetTrackResource(_client, data);
        }

        async ValueTask<MediaAssetTrackResource> IOperationSource<MediaAssetTrackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MediaAssetTrackData.DeserializeMediaAssetTrackData(document.RootElement);
            return new MediaAssetTrackResource(_client, data);
        }
    }
}
