// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Media.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMediaArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMediaArmClient"/> class for mocking. </summary>
        protected MockableMediaArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMediaArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMediaArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMediaArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaServicesAccountFilterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaServicesAccountFilterResource.CreateResourceIdentifier" /> to create a <see cref="MediaServicesAccountFilterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaServicesAccountFilterResource"/> object. </returns>
        public virtual MediaServicesAccountFilterResource GetMediaServicesAccountFilterResource(ResourceIdentifier id)
        {
            MediaServicesAccountFilterResource.ValidateResourceId(id);
            return new MediaServicesAccountFilterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaServicesAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaServicesAccountResource.CreateResourceIdentifier" /> to create a <see cref="MediaServicesAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaServicesAccountResource"/> object. </returns>
        public virtual MediaServicesAccountResource GetMediaServicesAccountResource(ResourceIdentifier id)
        {
            MediaServicesAccountResource.ValidateResourceId(id);
            return new MediaServicesAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaServicesPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaServicesPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="MediaServicesPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaServicesPrivateLinkResource"/> object. </returns>
        public virtual MediaServicesPrivateLinkResource GetMediaServicesPrivateLinkResource(ResourceIdentifier id)
        {
            MediaServicesPrivateLinkResource.ValidateResourceId(id);
            return new MediaServicesPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaServicesPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaServicesPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="MediaServicesPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaServicesPrivateEndpointConnectionResource"/> object. </returns>
        public virtual MediaServicesPrivateEndpointConnectionResource GetMediaServicesPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            MediaServicesPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new MediaServicesPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaAssetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaAssetResource.CreateResourceIdentifier" /> to create a <see cref="MediaAssetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaAssetResource"/> object. </returns>
        public virtual MediaAssetResource GetMediaAssetResource(ResourceIdentifier id)
        {
            MediaAssetResource.ValidateResourceId(id);
            return new MediaAssetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaAssetFilterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaAssetFilterResource.CreateResourceIdentifier" /> to create a <see cref="MediaAssetFilterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaAssetFilterResource"/> object. </returns>
        public virtual MediaAssetFilterResource GetMediaAssetFilterResource(ResourceIdentifier id)
        {
            MediaAssetFilterResource.ValidateResourceId(id);
            return new MediaAssetFilterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaAssetTrackResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaAssetTrackResource.CreateResourceIdentifier" /> to create a <see cref="MediaAssetTrackResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaAssetTrackResource"/> object. </returns>
        public virtual MediaAssetTrackResource GetMediaAssetTrackResource(ResourceIdentifier id)
        {
            MediaAssetTrackResource.ValidateResourceId(id);
            return new MediaAssetTrackResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ContentKeyPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ContentKeyPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ContentKeyPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ContentKeyPolicyResource"/> object. </returns>
        public virtual ContentKeyPolicyResource GetContentKeyPolicyResource(ResourceIdentifier id)
        {
            ContentKeyPolicyResource.ValidateResourceId(id);
            return new ContentKeyPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaTransformResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaTransformResource.CreateResourceIdentifier" /> to create a <see cref="MediaTransformResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaTransformResource"/> object. </returns>
        public virtual MediaTransformResource GetMediaTransformResource(ResourceIdentifier id)
        {
            MediaTransformResource.ValidateResourceId(id);
            return new MediaTransformResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaJobResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaJobResource.CreateResourceIdentifier" /> to create a <see cref="MediaJobResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaJobResource"/> object. </returns>
        public virtual MediaJobResource GetMediaJobResource(ResourceIdentifier id)
        {
            MediaJobResource.ValidateResourceId(id);
            return new MediaJobResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="StreamingPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="StreamingPolicyResource.CreateResourceIdentifier" /> to create a <see cref="StreamingPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="StreamingPolicyResource"/> object. </returns>
        public virtual StreamingPolicyResource GetStreamingPolicyResource(ResourceIdentifier id)
        {
            StreamingPolicyResource.ValidateResourceId(id);
            return new StreamingPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="StreamingLocatorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="StreamingLocatorResource.CreateResourceIdentifier" /> to create a <see cref="StreamingLocatorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="StreamingLocatorResource"/> object. </returns>
        public virtual StreamingLocatorResource GetStreamingLocatorResource(ResourceIdentifier id)
        {
            StreamingLocatorResource.ValidateResourceId(id);
            return new StreamingLocatorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaLiveEventResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaLiveEventResource.CreateResourceIdentifier" /> to create a <see cref="MediaLiveEventResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaLiveEventResource"/> object. </returns>
        public virtual MediaLiveEventResource GetMediaLiveEventResource(ResourceIdentifier id)
        {
            MediaLiveEventResource.ValidateResourceId(id);
            return new MediaLiveEventResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MediaLiveOutputResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MediaLiveOutputResource.CreateResourceIdentifier" /> to create a <see cref="MediaLiveOutputResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MediaLiveOutputResource"/> object. </returns>
        public virtual MediaLiveOutputResource GetMediaLiveOutputResource(ResourceIdentifier id)
        {
            MediaLiveOutputResource.ValidateResourceId(id);
            return new MediaLiveOutputResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="StreamingEndpointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="StreamingEndpointResource.CreateResourceIdentifier" /> to create a <see cref="StreamingEndpointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="StreamingEndpointResource"/> object. </returns>
        public virtual StreamingEndpointResource GetStreamingEndpointResource(ResourceIdentifier id)
        {
            StreamingEndpointResource.ValidateResourceId(id);
            return new StreamingEndpointResource(Client, id);
        }
    }
}
