// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Media.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media
{
    /// <summary>
    /// A class representing the ContentKeyPolicy data model.
    /// A Content Key Policy resource.
    /// </summary>
    public partial class ContentKeyPolicyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyData"/>. </summary>
        public ContentKeyPolicyData()
        {
            Options = new ChangeTrackingList<ContentKeyPolicyOption>();
        }

        /// <summary> Initializes a new instance of <see cref="ContentKeyPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyId"> The legacy Policy ID. </param>
        /// <param name="createdOn"> The creation date of the Policy. </param>
        /// <param name="lastModifiedOn"> The last modified date of the Policy. </param>
        /// <param name="description"> A description for the Policy. </param>
        /// <param name="options"> The Key Policy options. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContentKeyPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, Guid? policyId, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, string description, IList<ContentKeyPolicyOption> options, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PolicyId = policyId;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            Description = description;
            Options = options;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The legacy Policy ID. </summary>
        public Guid? PolicyId { get; }
        /// <summary> The creation date of the Policy. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The last modified date of the Policy. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> A description for the Policy. </summary>
        public string Description { get; set; }
        /// <summary> The Key Policy options. </summary>
        public IList<ContentKeyPolicyOption> Options { get; }
    }
}
