// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Media.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmMediaModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Media.MediaServicesAccountFilterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="presentationTimeRange"> The presentation time range. </param>
        /// <param name="firstQualityBitrate"> The first quality. </param>
        /// <param name="tracks"> The tracks selection conditions. </param>
        /// <returns> A new <see cref="Media.MediaServicesAccountFilterData"/> instance for mocking. </returns>
        public static MediaServicesAccountFilterData MediaServicesAccountFilterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, PresentationTimeRange presentationTimeRange = null, int? firstQualityBitrate = null, IEnumerable<FilterTrackSelection> tracks = null)
        {
            tracks ??= new List<FilterTrackSelection>();

            return new MediaServicesAccountFilterData(
                id,
                name,
                resourceType,
                systemData,
                presentationTimeRange,
                firstQualityBitrate.HasValue ? new FirstQuality(firstQualityBitrate.Value, serializedAdditionalRawData: null) : null,
                tracks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaServicesAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The Managed Identity for the Media Services account. </param>
        /// <param name="mediaServicesAccountId"> The Media Services account ID. </param>
        /// <param name="storageAccounts"> The storage accounts for this resource. </param>
        /// <param name="storageAuthentication"></param>
        /// <param name="encryption"> The account encryption properties. </param>
        /// <param name="keyDeliveryAccessControl"> The Key Delivery properties for Media Services account. </param>
        /// <param name="publicNetworkAccess"> Whether or not public network access is allowed for resources under the Media Services account. </param>
        /// <param name="provisioningState"> Provisioning state of the Media Services account. </param>
        /// <param name="privateEndpointConnections"> The Private Endpoint Connections created for the Media Service account. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used. </param>
        /// <returns> A new <see cref="Media.MediaServicesAccountData"/> instance for mocking. </returns>
        public static MediaServicesAccountData MediaServicesAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, Guid? mediaServicesAccountId = null, IEnumerable<MediaServicesStorageAccount> storageAccounts = null, MediaStorageAuthentication? storageAuthentication = null, AccountEncryption encryption = null, MediaAccessControl keyDeliveryAccessControl = null, MediaServicesPublicNetworkAccess? publicNetworkAccess = null, MediaServicesProvisioningState? provisioningState = null, IEnumerable<MediaServicesPrivateEndpointConnectionData> privateEndpointConnections = null, MediaServicesMinimumTlsVersion? minimumTlsVersion = null)
        {
            tags ??= new Dictionary<string, string>();
            storageAccounts ??= new List<MediaServicesStorageAccount>();
            privateEndpointConnections ??= new List<MediaServicesPrivateEndpointConnectionData>();

            return new MediaServicesAccountData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                mediaServicesAccountId,
                storageAccounts?.ToList(),
                storageAuthentication,
                encryption,
                keyDeliveryAccessControl != null ? new MediaKeyDelivery(keyDeliveryAccessControl, serializedAdditionalRawData: null) : null,
                publicNetworkAccess,
                provisioningState,
                privateEndpointConnections?.ToList(),
                minimumTlsVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaServicesStorageAccount"/>. </summary>
        /// <param name="id"> The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts. </param>
        /// <param name="accountType"> The type of the storage account. </param>
        /// <param name="identity"> The storage account identity. </param>
        /// <param name="status"> The current status of the storage account mapping. </param>
        /// <returns> A new <see cref="Models.MediaServicesStorageAccount"/> instance for mocking. </returns>
        public static MediaServicesStorageAccount MediaServicesStorageAccount(ResourceIdentifier id = null, MediaServicesStorageAccountType accountType = default, ResourceIdentity identity = null, string status = null)
        {
            return new MediaServicesStorageAccount(id, accountType, identity, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AccountEncryption"/>. </summary>
        /// <param name="keyType"> The type of key used to encrypt the Account Key. </param>
        /// <param name="keyVaultProperties"> The properties of the key used to encrypt the account. </param>
        /// <param name="identity"> The Key Vault identity. </param>
        /// <param name="status"> The current status of the Key Vault mapping. </param>
        /// <returns> A new <see cref="Models.AccountEncryption"/> instance for mocking. </returns>
        public static AccountEncryption AccountEncryption(AccountEncryptionKeyType keyType = default, KeyVaultProperties keyVaultProperties = null, ResourceIdentity identity = null, string status = null)
        {
            return new AccountEncryption(keyType, keyVaultProperties, identity, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KeyVaultProperties"/>. </summary>
        /// <param name="keyIdentifier"> The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey). </param>
        /// <param name="currentKeyIdentifier"> The current key used to encrypt the Media Services account, including the key version. </param>
        /// <returns> A new <see cref="Models.KeyVaultProperties"/> instance for mocking. </returns>
        public static KeyVaultProperties KeyVaultProperties(string keyIdentifier = null, string currentKeyIdentifier = null)
        {
            return new KeyVaultProperties(keyIdentifier, currentKeyIdentifier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaServicesPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="Media.MediaServicesPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static MediaServicesPrivateEndpointConnectionData MediaServicesPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, MediaPrivateLinkServiceConnectionState connectionState = null, MediaPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            return new MediaServicesPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaServicesAccountPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="identity"> The Managed Identity for the Media Services account. </param>
        /// <param name="mediaServiceId"> The Media Services account ID. </param>
        /// <param name="storageAccounts"> The storage accounts for this resource. </param>
        /// <param name="storageAuthentication"></param>
        /// <param name="encryption"> The account encryption properties. </param>
        /// <param name="keyDeliveryAccessControl"> The Key Delivery properties for Media Services account. </param>
        /// <param name="publicNetworkAccess"> Whether or not public network access is allowed for resources under the Media Services account. </param>
        /// <param name="provisioningState"> Provisioning state of the Media Services account. </param>
        /// <param name="privateEndpointConnections"> The Private Endpoint Connections created for the Media Service account. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used. </param>
        /// <returns> A new <see cref="Models.MediaServicesAccountPatch"/> instance for mocking. </returns>
        public static MediaServicesAccountPatch MediaServicesAccountPatch(IDictionary<string, string> tags = null, ManagedServiceIdentity identity = null, Guid? mediaServiceId = null, IEnumerable<MediaServicesStorageAccount> storageAccounts = null, MediaStorageAuthentication? storageAuthentication = null, AccountEncryption encryption = null, MediaAccessControl keyDeliveryAccessControl = null, MediaServicesPublicNetworkAccess? publicNetworkAccess = null, MediaServicesProvisioningState? provisioningState = null, IEnumerable<MediaServicesPrivateEndpointConnectionData> privateEndpointConnections = null, MediaServicesMinimumTlsVersion? minimumTlsVersion = null)
        {
            tags ??= new Dictionary<string, string>();
            storageAccounts ??= new List<MediaServicesStorageAccount>();
            privateEndpointConnections ??= new List<MediaServicesPrivateEndpointConnectionData>();

            return new MediaServicesAccountPatch(
                tags,
                identity,
                mediaServiceId,
                storageAccounts?.ToList(),
                storageAuthentication,
                encryption,
                keyDeliveryAccessControl != null ? new MediaKeyDelivery(keyDeliveryAccessControl, serializedAdditionalRawData: null) : null,
                publicNetworkAccess,
                provisioningState,
                privateEndpointConnections?.ToList(),
                minimumTlsVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaServicesEdgePolicies"/>. </summary>
        /// <param name="usageDataCollectionPolicy"></param>
        /// <returns> A new <see cref="Models.MediaServicesEdgePolicies"/> instance for mocking. </returns>
        public static MediaServicesEdgePolicies MediaServicesEdgePolicies(EdgeUsageDataCollectionPolicy usageDataCollectionPolicy = null)
        {
            return new MediaServicesEdgePolicies(usageDataCollectionPolicy, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EdgeUsageDataCollectionPolicy"/>. </summary>
        /// <param name="dataCollectionFrequency"> Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H. </param>
        /// <param name="dataReportingFrequency"> Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H. </param>
        /// <param name="maxAllowedUnreportedUsageDuration"> Maximum time for which the functionality of the device will not be hampered for not reporting the usage data. </param>
        /// <param name="eventHubDetails"> Details of Event Hub where the usage will be reported. </param>
        /// <returns> A new <see cref="Models.EdgeUsageDataCollectionPolicy"/> instance for mocking. </returns>
        public static EdgeUsageDataCollectionPolicy EdgeUsageDataCollectionPolicy(string dataCollectionFrequency = null, string dataReportingFrequency = null, TimeSpan? maxAllowedUnreportedUsageDuration = null, EdgeUsageDataEventHub eventHubDetails = null)
        {
            return new EdgeUsageDataCollectionPolicy(dataCollectionFrequency, dataReportingFrequency, maxAllowedUnreportedUsageDuration, eventHubDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EdgeUsageDataEventHub"/>. </summary>
        /// <param name="name"> Name of the Event Hub where usage will be reported. </param>
        /// <param name="namespace"> Namespace of the Event Hub where usage will be reported. </param>
        /// <param name="token"> SAS token needed to interact with Event Hub. </param>
        /// <returns> A new <see cref="Models.EdgeUsageDataEventHub"/> instance for mocking. </returns>
        public static EdgeUsageDataEventHub EdgeUsageDataEventHub(string name = null, string @namespace = null, string token = null)
        {
            return new EdgeUsageDataEventHub(name, @namespace, token, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaServicesPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Media.MediaServicesPrivateLinkResourceData"/> instance for mocking. </returns>
        public static MediaServicesPrivateLinkResourceData MediaServicesPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new MediaServicesPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaServicesNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Specifies if the name is available. </param>
        /// <param name="reason"> Specifies the reason if the name is not available. </param>
        /// <param name="message"> Specifies the detailed reason if the name is not available. </param>
        /// <returns> A new <see cref="Models.MediaServicesNameAvailabilityResult"/> instance for mocking. </returns>
        public static MediaServicesNameAvailabilityResult MediaServicesNameAvailabilityResult(bool isNameAvailable = default, string reason = null, string message = null)
        {
            return new MediaServicesNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaAssetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="assetId"> The Asset ID. </param>
        /// <param name="createdOn"> The creation date of the Asset. </param>
        /// <param name="lastModifiedOn"> The last modified date of the Asset. </param>
        /// <param name="alternateId"> The alternate ID of the Asset. </param>
        /// <param name="description"> The Asset description. </param>
        /// <param name="container"> The name of the asset blob container. </param>
        /// <param name="storageAccountName"> The name of the storage account. </param>
        /// <param name="storageEncryptionFormat"> The Asset encryption format. One of None or MediaStorageEncryption. </param>
        /// <param name="encryptionScope"> The Asset container encryption scope in the storage account. </param>
        /// <returns> A new <see cref="Media.MediaAssetData"/> instance for mocking. </returns>
        public static MediaAssetData MediaAssetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? assetId = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null, string alternateId = null, string description = null, string container = null, string storageAccountName = null, MediaAssetStorageEncryptionFormat? storageEncryptionFormat = null, string encryptionScope = null)
        {
            return new MediaAssetData(
                id,
                name,
                resourceType,
                systemData,
                assetId,
                createdOn,
                lastModifiedOn,
                alternateId,
                description,
                container,
                storageAccountName,
                storageEncryptionFormat,
                encryptionScope,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageEncryptedAssetDecryptionInfo"/>. </summary>
        /// <param name="key"> The Asset File storage encryption key. </param>
        /// <param name="assetFileEncryptionMetadata"> Asset File encryption metadata. </param>
        /// <returns> A new <see cref="Models.StorageEncryptedAssetDecryptionInfo"/> instance for mocking. </returns>
        public static StorageEncryptedAssetDecryptionInfo StorageEncryptedAssetDecryptionInfo(byte[] key = null, IEnumerable<MediaAssetFileEncryptionMetadata> assetFileEncryptionMetadata = null)
        {
            assetFileEncryptionMetadata ??= new List<MediaAssetFileEncryptionMetadata>();

            return new StorageEncryptedAssetDecryptionInfo(key, assetFileEncryptionMetadata?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaAssetFileEncryptionMetadata"/>. </summary>
        /// <param name="initializationVector"> The Asset File initialization vector. </param>
        /// <param name="assetFileName"> The Asset File name. </param>
        /// <param name="assetFileId"> The Asset File Id. </param>
        /// <returns> A new <see cref="Models.MediaAssetFileEncryptionMetadata"/> instance for mocking. </returns>
        public static MediaAssetFileEncryptionMetadata MediaAssetFileEncryptionMetadata(string initializationVector = null, string assetFileName = null, Guid assetFileId = default)
        {
            return new MediaAssetFileEncryptionMetadata(initializationVector, assetFileName, assetFileId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaAssetStreamingLocator"/>. </summary>
        /// <param name="name"> Streaming Locator name. </param>
        /// <param name="assetName"> Asset Name. </param>
        /// <param name="createdOn"> The creation time of the Streaming Locator. </param>
        /// <param name="startOn"> The start time of the Streaming Locator. </param>
        /// <param name="endOn"> The end time of the Streaming Locator. </param>
        /// <param name="streamingLocatorId"> StreamingLocatorId of the Streaming Locator. </param>
        /// <param name="streamingPolicyName"> Name of the Streaming Policy used by this Streaming Locator. </param>
        /// <param name="defaultContentKeyPolicyName"> Name of the default ContentKeyPolicy used by this Streaming Locator. </param>
        /// <returns> A new <see cref="Models.MediaAssetStreamingLocator"/> instance for mocking. </returns>
        public static MediaAssetStreamingLocator MediaAssetStreamingLocator(string name = null, string assetName = null, DateTimeOffset? createdOn = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, Guid? streamingLocatorId = null, string streamingPolicyName = null, string defaultContentKeyPolicyName = null)
        {
            return new MediaAssetStreamingLocator(
                name,
                assetName,
                createdOn,
                startOn,
                endOn,
                streamingLocatorId,
                streamingPolicyName,
                defaultContentKeyPolicyName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaAssetFilterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="presentationTimeRange"> The presentation time range. </param>
        /// <param name="firstQualityBitrate"> The first quality. </param>
        /// <param name="tracks"> The tracks selection conditions. </param>
        /// <returns> A new <see cref="Media.MediaAssetFilterData"/> instance for mocking. </returns>
        public static MediaAssetFilterData MediaAssetFilterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, PresentationTimeRange presentationTimeRange = null, int? firstQualityBitrate = null, IEnumerable<FilterTrackSelection> tracks = null)
        {
            tracks ??= new List<FilterTrackSelection>();

            return new MediaAssetFilterData(
                id,
                name,
                resourceType,
                systemData,
                presentationTimeRange,
                firstQualityBitrate.HasValue ? new FirstQuality(firstQualityBitrate.Value, serializedAdditionalRawData: null) : null,
                tracks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaAssetTrackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="track">
        /// Detailed information about a track in the asset.
        /// Please note <see cref="MediaAssetTrackBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AudioTrack"/>, <see cref="Models.TextTrack"/> and <see cref="VideoTrack"/>.
        /// </param>
        /// <param name="provisioningState"> Provisioning state of the asset track. </param>
        /// <returns> A new <see cref="Media.MediaAssetTrackData"/> instance for mocking. </returns>
        public static MediaAssetTrackData MediaAssetTrackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MediaAssetTrackBase track = null, MediaServicesProvisioningState? provisioningState = null)
        {
            return new MediaAssetTrackData(
                id,
                name,
                resourceType,
                systemData,
                track,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.ContentKeyPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyId"> The legacy Policy ID. </param>
        /// <param name="createdOn"> The creation date of the Policy. </param>
        /// <param name="lastModifiedOn"> The last modified date of the Policy. </param>
        /// <param name="description"> A description for the Policy. </param>
        /// <param name="options"> The Key Policy options. </param>
        /// <returns> A new <see cref="Media.ContentKeyPolicyData"/> instance for mocking. </returns>
        public static ContentKeyPolicyData ContentKeyPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? policyId = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null, string description = null, IEnumerable<ContentKeyPolicyOption> options = null)
        {
            options ??= new List<ContentKeyPolicyOption>();

            return new ContentKeyPolicyData(
                id,
                name,
                resourceType,
                systemData,
                policyId,
                createdOn,
                lastModifiedOn,
                description,
                options?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContentKeyPolicyProperties"/>. </summary>
        /// <param name="policyId"> The legacy Policy ID. </param>
        /// <param name="createdOn"> The creation date of the Policy. </param>
        /// <param name="lastModifiedOn"> The last modified date of the Policy. </param>
        /// <param name="description"> A description for the Policy. </param>
        /// <param name="options"> The Key Policy options. </param>
        /// <returns> A new <see cref="Models.ContentKeyPolicyProperties"/> instance for mocking. </returns>
        public static ContentKeyPolicyProperties ContentKeyPolicyProperties(Guid? policyId = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null, string description = null, IEnumerable<ContentKeyPolicyOption> options = null)
        {
            options ??= new List<ContentKeyPolicyOption>();

            return new ContentKeyPolicyProperties(
                policyId,
                createdOn,
                lastModifiedOn,
                description,
                options?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContentKeyPolicyOption"/>. </summary>
        /// <param name="policyOptionId"> The legacy Policy Option ID. </param>
        /// <param name="name"> The Policy Option description. </param>
        /// <param name="configuration">
        /// The key delivery configuration.
        /// Please note <see cref="ContentKeyPolicyConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyClearKeyConfiguration"/>, <see cref="ContentKeyPolicyFairPlayConfiguration"/>, <see cref="ContentKeyPolicyPlayReadyConfiguration"/>, <see cref="ContentKeyPolicyUnknownConfiguration"/> and <see cref="ContentKeyPolicyWidevineConfiguration"/>.
        /// </param>
        /// <param name="restriction">
        /// The requirements that must be met to deliver keys with this configuration
        /// Please note <see cref="ContentKeyPolicyRestriction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContentKeyPolicyOpenRestriction"/>, <see cref="ContentKeyPolicyTokenRestriction"/> and <see cref="ContentKeyPolicyUnknownRestriction"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ContentKeyPolicyOption"/> instance for mocking. </returns>
        public static ContentKeyPolicyOption ContentKeyPolicyOption(Guid? policyOptionId = null, string name = null, ContentKeyPolicyConfiguration configuration = null, ContentKeyPolicyRestriction restriction = null)
        {
            return new ContentKeyPolicyOption(policyOptionId, name, configuration, restriction, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaTransformData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="description"> An optional verbose description of the Transform. </param>
        /// <param name="lastModifiedOn"> The UTC date and time when the Transform was last updated, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="outputs"> An array of one or more TransformOutputs that the Transform should generate. </param>
        /// <returns> A new <see cref="Media.MediaTransformData"/> instance for mocking. </returns>
        public static MediaTransformData MediaTransformData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, string description = null, DateTimeOffset? lastModifiedOn = null, IEnumerable<MediaTransformOutput> outputs = null)
        {
            outputs ??= new List<MediaTransformOutput>();

            return new MediaTransformData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                description,
                lastModifiedOn,
                outputs?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="state"> The current state of the job. </param>
        /// <param name="description"> Optional customer supplied description of the Job. </param>
        /// <param name="input">
        /// The inputs for the Job.
        /// Please note <see cref="MediaJobInputBasicProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MediaJobInputAsset"/>, <see cref="MediaJobInputClip"/>, <see cref="MediaJobInputHttp"/>, <see cref="MediaJobInputs"/> and <see cref="MediaJobInputSequence"/>.
        /// </param>
        /// <param name="lastModifiedOn"> The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format. </param>
        /// <param name="outputs">
        /// The outputs for the Job.
        /// Please note <see cref="Models.MediaJobOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MediaJobOutputAsset"/>.
        /// </param>
        /// <param name="priority"> Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal. </param>
        /// <param name="correlationData"> Customer provided key, value pairs that will be returned in Job and JobOutput state events. </param>
        /// <param name="startOn"> The UTC date and time at which this Job began processing. </param>
        /// <param name="endOn"> The UTC date and time at which this Job finished processing. </param>
        /// <returns> A new <see cref="Media.MediaJobData"/> instance for mocking. </returns>
        public static MediaJobData MediaJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, MediaJobState? state = null, string description = null, MediaJobInputBasicProperties input = null, DateTimeOffset? lastModifiedOn = null, IEnumerable<MediaJobOutput> outputs = null, MediaJobPriority? priority = null, IDictionary<string, string> correlationData = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null)
        {
            outputs ??= new List<MediaJobOutput>();
            correlationData ??= new Dictionary<string, string>();

            return new MediaJobData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                state,
                description,
                input,
                lastModifiedOn,
                outputs?.ToList(),
                priority,
                correlationData,
                startOn,
                endOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaJobOutput"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="error"> If the JobOutput is in the Error state, it contains the details of the error. </param>
        /// <param name="presetOverride">
        /// A preset used to override the preset in the corresponding transform output.
        /// Please note <see cref="MediaTransformPreset"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AudioAnalyzerPreset"/>, <see cref="BuiltInStandardEncoderPreset"/>, <see cref="StandardEncoderPreset"/> and <see cref="VideoAnalyzerPreset"/>.
        /// </param>
        /// <param name="state"> Describes the state of the JobOutput. </param>
        /// <param name="progress"> If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property. </param>
        /// <param name="label"> A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform. </param>
        /// <param name="startOn"> The UTC date and time at which this Job Output began processing. </param>
        /// <param name="endOn"> The UTC date and time at which this Job Output finished processing. </param>
        /// <returns> A new <see cref="Models.MediaJobOutput"/> instance for mocking. </returns>
        public static MediaJobOutput MediaJobOutput(string odataType = null, MediaJobError error = null, MediaTransformPreset presetOverride = null, MediaJobState? state = null, int? progress = null, string label = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null)
        {
            return new UnknownJobOutput(
                odataType,
                error,
                presetOverride,
                state,
                progress,
                label,
                startOn,
                endOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaJobError"/>. </summary>
        /// <param name="code"> Error code describing the error. </param>
        /// <param name="message"> A human-readable language-dependent representation of the error. </param>
        /// <param name="category"> Helps with categorization of errors. </param>
        /// <param name="retry"> Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal. </param>
        /// <param name="details"> An array of details about specific errors that led to this reported error. </param>
        /// <returns> A new <see cref="Models.MediaJobError"/> instance for mocking. </returns>
        public static MediaJobError MediaJobError(MediaJobErrorCode? code = null, string message = null, MediaJobErrorCategory? category = null, MediaJobRetry? retry = null, IEnumerable<MediaJobErrorDetail> details = null)
        {
            details ??= new List<MediaJobErrorDetail>();

            return new MediaJobError(
                code,
                message,
                category,
                retry,
                details?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaJobErrorDetail"/>. </summary>
        /// <param name="code"> Code describing the error detail. </param>
        /// <param name="message"> A human-readable representation of the error. </param>
        /// <returns> A new <see cref="Models.MediaJobErrorDetail"/> instance for mocking. </returns>
        public static MediaJobErrorDetail MediaJobErrorDetail(string code = null, string message = null)
        {
            return new MediaJobErrorDetail(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.StreamingPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Creation time of Streaming Policy. </param>
        /// <param name="defaultContentKeyPolicyName"> Default ContentKey used by current Streaming Policy. </param>
        /// <param name="envelopeEncryption"> Configuration of EnvelopeEncryption. </param>
        /// <param name="commonEncryptionCenc"> Configuration of CommonEncryptionCenc. </param>
        /// <param name="commonEncryptionCbcs"> Configuration of CommonEncryptionCbcs. </param>
        /// <param name="noEncryptionEnabledProtocols"> Configurations of NoEncryption. </param>
        /// <returns> A new <see cref="Media.StreamingPolicyData"/> instance for mocking. </returns>
        public static StreamingPolicyData StreamingPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, string defaultContentKeyPolicyName = null, EnvelopeEncryption envelopeEncryption = null, CommonEncryptionCenc commonEncryptionCenc = null, CommonEncryptionCbcs commonEncryptionCbcs = null, MediaEnabledProtocols noEncryptionEnabledProtocols = null)
        {
            return new StreamingPolicyData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                defaultContentKeyPolicyName,
                envelopeEncryption,
                commonEncryptionCenc,
                commonEncryptionCbcs,
                noEncryptionEnabledProtocols != null ? new NoEncryption(noEncryptionEnabledProtocols, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.StreamingLocatorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="assetName"> Asset Name. </param>
        /// <param name="createdOn"> The creation time of the Streaming Locator. </param>
        /// <param name="startOn"> The start time of the Streaming Locator. </param>
        /// <param name="endOn"> The end time of the Streaming Locator. </param>
        /// <param name="streamingLocatorId"> The StreamingLocatorId of the Streaming Locator. </param>
        /// <param name="streamingPolicyName"> Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'. </param>
        /// <param name="defaultContentKeyPolicyName"> Name of the default ContentKeyPolicy used by this Streaming Locator. </param>
        /// <param name="contentKeys"> The ContentKeys used by this Streaming Locator. </param>
        /// <param name="alternativeMediaId"> Alternative Media ID of this Streaming Locator. </param>
        /// <param name="filters"> A list of asset or account filters which apply to this streaming locator. </param>
        /// <returns> A new <see cref="Media.StreamingLocatorData"/> instance for mocking. </returns>
        public static StreamingLocatorData StreamingLocatorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string assetName = null, DateTimeOffset? createdOn = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, Guid? streamingLocatorId = null, string streamingPolicyName = null, string defaultContentKeyPolicyName = null, IEnumerable<StreamingLocatorContentKey> contentKeys = null, string alternativeMediaId = null, IEnumerable<string> filters = null)
        {
            contentKeys ??= new List<StreamingLocatorContentKey>();
            filters ??= new List<string>();

            return new StreamingLocatorData(
                id,
                name,
                resourceType,
                systemData,
                assetName,
                createdOn,
                startOn,
                endOn,
                streamingLocatorId,
                streamingPolicyName,
                defaultContentKeyPolicyName,
                contentKeys?.ToList(),
                alternativeMediaId,
                filters?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingLocatorContentKey"/>. </summary>
        /// <param name="id"> ID of Content Key. </param>
        /// <param name="keyType"> Encryption type of Content Key. </param>
        /// <param name="labelReferenceInStreamingPolicy"> Label of Content Key as specified in the Streaming Policy. </param>
        /// <param name="value"> Value of Content Key. </param>
        /// <param name="policyName"> ContentKeyPolicy used by Content Key. </param>
        /// <param name="tracks"> Tracks which use this Content Key. </param>
        /// <returns> A new <see cref="Models.StreamingLocatorContentKey"/> instance for mocking. </returns>
        public static StreamingLocatorContentKey StreamingLocatorContentKey(Guid id = default, StreamingLocatorContentKeyType? keyType = null, string labelReferenceInStreamingPolicy = null, string value = null, string policyName = null, IEnumerable<MediaTrackSelection> tracks = null)
        {
            tracks ??= new List<MediaTrackSelection>();

            return new StreamingLocatorContentKey(
                id,
                keyType,
                labelReferenceInStreamingPolicy,
                value,
                policyName,
                tracks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingPathsResult"/>. </summary>
        /// <param name="streamingPaths"> Streaming Paths supported by current Streaming Locator. </param>
        /// <param name="downloadPaths"> Download Paths supported by current Streaming Locator. </param>
        /// <returns> A new <see cref="Models.StreamingPathsResult"/> instance for mocking. </returns>
        public static StreamingPathsResult StreamingPathsResult(IEnumerable<StreamingPath> streamingPaths = null, IEnumerable<string> downloadPaths = null)
        {
            streamingPaths ??= new List<StreamingPath>();
            downloadPaths ??= new List<string>();

            return new StreamingPathsResult(streamingPaths?.ToList(), downloadPaths?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingPath"/>. </summary>
        /// <param name="streamingProtocol"> Streaming protocol. </param>
        /// <param name="encryptionScheme"> Encryption scheme. </param>
        /// <param name="paths"> Streaming paths for each protocol and encryptionScheme pair. </param>
        /// <returns> A new <see cref="Models.StreamingPath"/> instance for mocking. </returns>
        public static StreamingPath StreamingPath(StreamingPolicyStreamingProtocol streamingProtocol = default, StreamingPathEncryptionScheme encryptionScheme = default, IEnumerable<string> paths = null)
        {
            paths ??= new List<string>();

            return new StreamingPath(streamingProtocol, encryptionScheme, paths?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaLiveEventData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> A description for the live event. </param>
        /// <param name="input"> Live event input settings. It defines how the live event receives input from a contribution encoder. </param>
        /// <param name="preview"> Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output. </param>
        /// <param name="encoding"> Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used. </param>
        /// <param name="transcriptions"> Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature. </param>
        /// <param name="provisioningState"> The provisioning state of the live event. </param>
        /// <param name="resourceState"> The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information. </param>
        /// <param name="crossSiteAccessPolicies"> Live event cross site access policies. </param>
        /// <param name="useStaticHostname"> Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state. </param>
        /// <param name="hostnamePrefix"> When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center. </param>
        /// <param name="streamOptions"> The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'. </param>
        /// <param name="createdOn"> The creation time for the live event. </param>
        /// <param name="lastModifiedOn"> The last modified time of the live event. </param>
        /// <returns> A new <see cref="Media.MediaLiveEventData"/> instance for mocking. </returns>
        public static MediaLiveEventData MediaLiveEventData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, LiveEventInput input = null, LiveEventPreview preview = null, LiveEventEncoding encoding = null, IEnumerable<LiveEventTranscription> transcriptions = null, string provisioningState = null, LiveEventResourceState? resourceState = null, CrossSiteAccessPolicies crossSiteAccessPolicies = null, bool? useStaticHostname = null, string hostnamePrefix = null, IEnumerable<StreamOptionsFlag> streamOptions = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null)
        {
            tags ??= new Dictionary<string, string>();
            transcriptions ??= new List<LiveEventTranscription>();
            streamOptions ??= new List<StreamOptionsFlag>();

            return new MediaLiveEventData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                input,
                preview,
                encoding,
                transcriptions?.ToList(),
                provisioningState,
                resourceState,
                crossSiteAccessPolicies,
                useStaticHostname,
                hostnamePrefix,
                streamOptions?.ToList(),
                createdOn,
                lastModifiedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.MediaLiveOutputData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> The description of the live output. </param>
        /// <param name="assetName"> The asset that the live output will write to. </param>
        /// <param name="archiveWindowLength"> ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the asset for this live output. This also sets the maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window. </param>
        /// <param name="rewindWindowLength"> ISO 8601 time between 1 minute to the duration of archiveWindowLength to control seek-able window length during Live. The service won't use this property once LiveOutput stops. The archived VOD will have full content with original ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind window length. Service will use implicit default value 30m only if Live Event enables LL. </param>
        /// <param name="manifestName"> The manifest file name. If not provided, the service will generate one automatically. </param>
        /// <param name="hlsFragmentsPerTsSegment"> HTTP Live Streaming (HLS) packing setting for the live output. </param>
        /// <param name="outputSnapTime"> The initial timestamp that the live output will start at, any content before this value will not be archived. </param>
        /// <param name="createdOn"> The creation time the live output. </param>
        /// <param name="lastModifiedOn"> The time the live output was last modified. </param>
        /// <param name="provisioningState"> The provisioning state of the live output. </param>
        /// <param name="resourceState"> The resource state of the live output. </param>
        /// <returns> A new <see cref="Media.MediaLiveOutputData"/> instance for mocking. </returns>
        public static MediaLiveOutputData MediaLiveOutputData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, string assetName = null, TimeSpan? archiveWindowLength = null, TimeSpan? rewindWindowLength = null, string manifestName = null, int? hlsFragmentsPerTsSegment = null, long? outputSnapTime = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null, string provisioningState = null, LiveOutputResourceState? resourceState = null)
        {
            return new MediaLiveOutputData(
                id,
                name,
                resourceType,
                systemData,
                description,
                assetName,
                archiveWindowLength,
                rewindWindowLength,
                manifestName,
                hlsFragmentsPerTsSegment != null ? new Hls(hlsFragmentsPerTsSegment, serializedAdditionalRawData: null) : null,
                outputSnapTime,
                createdOn,
                lastModifiedOn,
                provisioningState,
                resourceState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Media.StreamingEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The streaming endpoint sku. </param>
        /// <param name="description"> The streaming endpoint description. </param>
        /// <param name="scaleUnits"> The number of scale units. Use the Scale operation to adjust this value. </param>
        /// <param name="availabilitySetName"> This feature is deprecated, do not set a value for this property. </param>
        /// <param name="accessControl"> The access control definition of the streaming endpoint. </param>
        /// <param name="maxCacheAge"> Max cache age. </param>
        /// <param name="customHostNames"> The custom host names of the streaming endpoint. </param>
        /// <param name="hostName"> The streaming endpoint host name. </param>
        /// <param name="isCdnEnabled"> The CDN enabled flag. </param>
        /// <param name="cdnProvider"> The CDN provider name. </param>
        /// <param name="cdnProfile"> The CDN profile name. </param>
        /// <param name="provisioningState"> The provisioning state of the streaming endpoint. </param>
        /// <param name="resourceState"> The resource state of the streaming endpoint. </param>
        /// <param name="crossSiteAccessPolicies"> The streaming endpoint access policies. </param>
        /// <param name="freeTrialEndOn"> The free trial expiration time. </param>
        /// <param name="createdOn"> The exact time the streaming endpoint was created. </param>
        /// <param name="lastModifiedOn"> The exact time the streaming endpoint was last modified. </param>
        /// <returns> A new <see cref="Media.StreamingEndpointData"/> instance for mocking. </returns>
        public static StreamingEndpointData StreamingEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, StreamingEndpointCurrentSku sku = null, string description = null, int? scaleUnits = null, string availabilitySetName = null, StreamingEndpointAccessControl accessControl = null, long? maxCacheAge = null, IEnumerable<string> customHostNames = null, string hostName = null, bool? isCdnEnabled = null, string cdnProvider = null, string cdnProfile = null, string provisioningState = null, StreamingEndpointResourceState? resourceState = null, CrossSiteAccessPolicies crossSiteAccessPolicies = null, DateTimeOffset? freeTrialEndOn = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null)
        {
            tags ??= new Dictionary<string, string>();
            customHostNames ??= new List<string>();

            return new StreamingEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                description,
                scaleUnits,
                availabilitySetName,
                accessControl,
                maxCacheAge,
                customHostNames?.ToList(),
                hostName,
                isCdnEnabled,
                cdnProvider,
                cdnProfile,
                provisioningState,
                resourceState,
                crossSiteAccessPolicies,
                freeTrialEndOn,
                createdOn,
                lastModifiedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingEndpointCurrentSku"/>. </summary>
        /// <param name="name"> The streaming endpoint sku name. </param>
        /// <param name="capacity"> The streaming endpoint sku capacity. </param>
        /// <returns> A new <see cref="Models.StreamingEndpointCurrentSku"/> instance for mocking. </returns>
        public static StreamingEndpointCurrentSku StreamingEndpointCurrentSku(string name = null, int? capacity = null)
        {
            return new StreamingEndpointCurrentSku(name, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingEndpointSkuInfo"/>. </summary>
        /// <param name="resourceType"></param>
        /// <param name="capacity"> The streaming endpoint sku capacity. </param>
        /// <param name="skuName"> The streaming endpoint sku. </param>
        /// <returns> A new <see cref="Models.StreamingEndpointSkuInfo"/> instance for mocking. </returns>
        public static StreamingEndpointSkuInfo StreamingEndpointSkuInfo(ResourceType? resourceType = null, StreamingEndpointCapacity capacity = null, string skuName = null)
        {
            return new StreamingEndpointSkuInfo(resourceType, capacity, skuName != null ? new StreamingEndpointSku(skuName, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StreamingEndpointCapacity"/>. </summary>
        /// <param name="scaleType"></param>
        /// <param name="default"> The streaming endpoint default capacity. </param>
        /// <param name="minimum"> The streaming endpoint minimum capacity. </param>
        /// <param name="maximum"> The streaming endpoint maximum capacity. </param>
        /// <returns> A new <see cref="Models.StreamingEndpointCapacity"/> instance for mocking. </returns>
        public static StreamingEndpointCapacity StreamingEndpointCapacity(string scaleType = null, int? @default = null, int? minimum = null, int? maximum = null)
        {
            return new StreamingEndpointCapacity(scaleType, @default, minimum, maximum, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AudioTrack"/>. </summary>
        /// <param name="fileName"> The file name to the source file. This file is located in the storage container of the asset. </param>
        /// <param name="displayName"> The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA. </param>
        /// <param name="languageCode"> The RFC5646 language code for the audio track. </param>
        /// <param name="hlsSettings"> The HLS specific setting for the audio track. </param>
        /// <param name="dashRole"> The DASH specific setting for the audio track. </param>
        /// <param name="mpeg4TrackId"> The MPEG-4 audio track ID for the audio track. </param>
        /// <param name="bitRate"> The stream bit rate for the audio track. </param>
        /// <returns> A new <see cref="Models.AudioTrack"/> instance for mocking. </returns>
        public static AudioTrack AudioTrack(string fileName = null, string displayName = null, string languageCode = null, HlsSettings hlsSettings = null, string dashRole = null, int? mpeg4TrackId = null, int? bitRate = null)
        {
            return new AudioTrack(
                "#Microsoft.Media.AudioTrack",
                serializedAdditionalRawData: null,
                fileName,
                displayName,
                languageCode,
                hlsSettings,
                dashRole != null ? new TrackDashSettings(dashRole, serializedAdditionalRawData: null) : null,
                mpeg4TrackId,
                bitRate);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TextTrack"/>. </summary>
        /// <param name="fileName"> The file name to the source file. This file is located in the storage container of the asset. </param>
        /// <param name="displayName"> The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA. </param>
        /// <param name="languageCode"> The RFC5646 language code for the text track. </param>
        /// <param name="playerVisibility"> When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible". </param>
        /// <param name="hlsSettings"> The HLS specific setting for the text track. </param>
        /// <returns> A new <see cref="Models.TextTrack"/> instance for mocking. </returns>
        public static TextTrack TextTrack(string fileName = null, string displayName = null, string languageCode = null, PlayerVisibility? playerVisibility = null, HlsSettings hlsSettings = null)
        {
            return new TextTrack(
                "#Microsoft.Media.TextTrack",
                serializedAdditionalRawData: null,
                fileName,
                displayName,
                languageCode,
                playerVisibility,
                hlsSettings);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MediaJobOutputAsset"/>. </summary>
        /// <param name="error"> If the JobOutput is in the Error state, it contains the details of the error. </param>
        /// <param name="presetOverride">
        /// A preset used to override the preset in the corresponding transform output.
        /// Please note <see cref="MediaTransformPreset"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AudioAnalyzerPreset"/>, <see cref="BuiltInStandardEncoderPreset"/>, <see cref="StandardEncoderPreset"/> and <see cref="VideoAnalyzerPreset"/>.
        /// </param>
        /// <param name="state"> Describes the state of the JobOutput. </param>
        /// <param name="progress"> If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property. </param>
        /// <param name="label"> A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform. </param>
        /// <param name="startOn"> The UTC date and time at which this Job Output began processing. </param>
        /// <param name="endOn"> The UTC date and time at which this Job Output finished processing. </param>
        /// <param name="assetName"> The name of the output Asset. </param>
        /// <returns> A new <see cref="Models.MediaJobOutputAsset"/> instance for mocking. </returns>
        public static MediaJobOutputAsset MediaJobOutputAsset(MediaJobError error = null, MediaTransformPreset presetOverride = null, MediaJobState? state = null, int? progress = null, string label = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string assetName = null)
        {
            return new MediaJobOutputAsset(
                "#Microsoft.Media.JobOutputAsset",
                error,
                presetOverride,
                state,
                progress,
                label,
                startOn,
                endOn,
                serializedAdditionalRawData: null,
                assetName);
        }
    }
}
