// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Media.Models;

namespace Azure.ResourceManager.Media.Samples
{
    public partial class Sample_StreamingPolicyCollection
    {
        // Lists Streaming Policies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListsStreamingPolicies()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-list.json
            // this example is just showing the usage of "StreamingPolicies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation and iterate over the result
            await foreach (StreamingPolicyResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a Streaming Policy by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAStreamingPolicyByName()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policy-get-by-name.json
            // this example is just showing the usage of "StreamingPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "clearStreamingPolicy";
            StreamingPolicyResource result = await collection.GetAsync(streamingPolicyName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Streaming Policy by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAStreamingPolicyByName()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policy-get-by-name.json
            // this example is just showing the usage of "StreamingPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "clearStreamingPolicy";
            bool result = await collection.ExistsAsync(streamingPolicyName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Streaming Policy by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAStreamingPolicyByName()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policy-get-by-name.json
            // this example is just showing the usage of "StreamingPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "clearStreamingPolicy";
            NullableResponse<StreamingPolicyResource> response = await collection.GetIfExistsAsync(streamingPolicyName);
            StreamingPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                StreamingPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Creates a Streaming Policy with ClearKey encryption in commonEncryptionCbcs.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithClearKeyEncryptionInCommonEncryptionCbcs()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-commonEncryptionCbcs-clearKeyEncryption.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
                CommonEncryptionCbcs = new CommonEncryptionCbcs()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, false, true, false),
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cbcsDefaultKey",
                        },
                    },
                    ClearKeyEncryptionCustomKeysAcquisitionUriTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with ClearKey encryption in commonEncryptionCenc.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithClearKeyEncryptionInCommonEncryptionCenc()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-commonEncryptionCenc-clearKeyEncryption.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
                CommonEncryptionCenc = new CommonEncryptionCenc()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, true, false, true),
                    ClearTracks =
{
new MediaTrackSelection()
{
TrackSelections =
{
new TrackPropertyCondition(TrackPropertyType.FourCC,TrackPropertyCompareOperation.Equal)
{
Value = "hev1",
}
},
}
},
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cencDefaultKey",
                        },
                    },
                    ClearKeyEncryptionCustomKeysAcquisitionUriTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with clear streaming
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithClearStreaming()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-clear.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "clearStreamingPolicy";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                NoEncryptionEnabledProtocols = new MediaEnabledProtocols(true, true, true, true),
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with commonEncryptionCbcs only
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithCommonEncryptionCbcsOnly()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-commonEncryptionCbcs-only.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
                CommonEncryptionCbcs = new CommonEncryptionCbcs()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, false, true, false),
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cbcsDefaultKey",
                        },
                    },
                    Drm = new CbcsDrmConfiguration()
                    {
                        FairPlay = new StreamingPolicyFairPlayConfiguration(true)
                        {
                            CustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
                        },
                    },
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with commonEncryptionCenc only
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithCommonEncryptionCencOnly()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-commonEncryptionCenc-only.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
                CommonEncryptionCenc = new CommonEncryptionCenc()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, true, false, true),
                    ClearTracks =
{
new MediaTrackSelection()
{
TrackSelections =
{
new TrackPropertyCondition(TrackPropertyType.FourCC,TrackPropertyCompareOperation.Equal)
{
Value = "hev1",
}
},
}
},
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cencDefaultKey",
                        },
                    },
                    Drm = new CencDrmConfiguration()
                    {
                        PlayReady = new StreamingPolicyPlayReadyConfiguration()
                        {
                            CustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
                            PlayReadyCustomAttributes = "PlayReady CustomAttributes",
                        },
                        WidevineCustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
                    },
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with envelopeEncryption only
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithEnvelopeEncryptionOnly()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-envelopeEncryption-only.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithClearKeyOptionAndTokenRestriction",
                EnvelopeEncryption = new EnvelopeEncryption()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, true, true, true),
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "aesDefaultKey",
                        },
                    },
                    CustomKeyAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates a Streaming Policy with secure streaming
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesAStreamingPolicyWithSecureStreaming()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/streaming-policies-create-secure-streaming.json
            // this example is just showing the usage of "StreamingPolicies_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaServicesAccountResource created on azure
            // for more information of creating MediaServicesAccountResource, please refer to the document of MediaServicesAccountResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            ResourceIdentifier mediaServicesAccountResourceId = MediaServicesAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            MediaServicesAccountResource mediaServicesAccount = client.GetMediaServicesAccountResource(mediaServicesAccountResourceId);

            // get the collection of this StreamingPolicyResource
            StreamingPolicyCollection collection = mediaServicesAccount.GetStreamingPolicies();

            // invoke the operation
            string streamingPolicyName = "UserCreatedSecureStreamingPolicy";
            StreamingPolicyData data = new StreamingPolicyData()
            {
                DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
                EnvelopeEncryption = new EnvelopeEncryption()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, true, true, true),
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "aesDefaultKey",
                        },
                    },
                    CustomKeyAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
                },
                CommonEncryptionCenc = new CommonEncryptionCenc()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, true, false, true),
                    ClearTracks =
{
new MediaTrackSelection()
{
TrackSelections =
{
new TrackPropertyCondition(TrackPropertyType.FourCC,TrackPropertyCompareOperation.Equal)
{
Value = "hev1",
}
},
}
},
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cencDefaultKey",
                        },
                    },
                    Drm = new CencDrmConfiguration()
                    {
                        PlayReady = new StreamingPolicyPlayReadyConfiguration()
                        {
                            CustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
                            PlayReadyCustomAttributes = "PlayReady CustomAttributes",
                        },
                        WidevineCustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
                    },
                },
                CommonEncryptionCbcs = new CommonEncryptionCbcs()
                {
                    EnabledProtocols = new MediaEnabledProtocols(false, false, true, false),
                    ContentKeys = new StreamingPolicyContentKeys()
                    {
                        DefaultKey = new EncryptionSchemeDefaultKey()
                        {
                            Label = "cbcsDefaultKey",
                        },
                    },
                    Drm = new CbcsDrmConfiguration()
                    {
                        FairPlay = new StreamingPolicyFairPlayConfiguration(true)
                        {
                            CustomLicenseAcquisitionUriTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
                        },
                    },
                },
            };
            ArmOperation<StreamingPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, streamingPolicyName, data);
            StreamingPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StreamingPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
