// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Media.Models;

namespace Azure.ResourceManager.Media.Samples
{
    public partial class Sample_MediaAssetTrackResource
    {
        // Get a Track by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetATrackByName()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/asset-tracks-get-by-name.json
            // this example is just showing the usage of "Tracks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaAssetTrackResource created on azure
            // for more information of creating MediaAssetTrackResource, please refer to the document of MediaAssetTrackResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            string assetName = "ClimbingMountRainer";
            string trackName = "text1";
            ResourceIdentifier mediaAssetTrackResourceId = MediaAssetTrackResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, assetName, trackName);
            MediaAssetTrackResource mediaAssetTrack = client.GetMediaAssetTrackResource(mediaAssetTrackResourceId);

            // invoke the operation
            MediaAssetTrackResource result = await mediaAssetTrack.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MediaAssetTrackData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a Track
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteATrack()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/asset-tracks-delete.json
            // this example is just showing the usage of "Tracks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaAssetTrackResource created on azure
            // for more information of creating MediaAssetTrackResource, please refer to the document of MediaAssetTrackResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            string assetName = "ClimbingMountRainer";
            string trackName = "text2";
            ResourceIdentifier mediaAssetTrackResourceId = MediaAssetTrackResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, assetName, trackName);
            MediaAssetTrackResource mediaAssetTrack = client.GetMediaAssetTrackResource(mediaAssetTrackResourceId);

            // invoke the operation
            await mediaAssetTrack.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Update a Track
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateATrack()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/asset-tracks-update.json
            // this example is just showing the usage of "Tracks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaAssetTrackResource created on azure
            // for more information of creating MediaAssetTrackResource, please refer to the document of MediaAssetTrackResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            string assetName = "ClimbingMountRainer";
            string trackName = "text1";
            ResourceIdentifier mediaAssetTrackResourceId = MediaAssetTrackResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, assetName, trackName);
            MediaAssetTrackResource mediaAssetTrack = client.GetMediaAssetTrackResource(mediaAssetTrackResourceId);

            // invoke the operation
            MediaAssetTrackData data = new MediaAssetTrackData()
            {
                Track = new TextTrack()
                {
                    DisplayName = "A new name",
                },
            };
            ArmOperation<MediaAssetTrackResource> lro = await mediaAssetTrack.UpdateAsync(WaitUntil.Completed, data);
            MediaAssetTrackResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MediaAssetTrackData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update the data for a tracks
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateTrackData_UpdateTheDataForATracks()
        {
            // Generated from example definition: specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2023-01-01/examples/asset-tracks-update-data.json
            // this example is just showing the usage of "Tracks_UpdateTrackData" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MediaAssetTrackResource created on azure
            // for more information of creating MediaAssetTrackResource, please refer to the document of MediaAssetTrackResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "contosorg";
            string accountName = "contosomedia";
            string assetName = "ClimbingMountRainer";
            string trackName = "text2";
            ResourceIdentifier mediaAssetTrackResourceId = MediaAssetTrackResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, assetName, trackName);
            MediaAssetTrackResource mediaAssetTrack = client.GetMediaAssetTrackResource(mediaAssetTrackResourceId);

            // invoke the operation
            await mediaAssetTrack.UpdateTrackDataAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
