// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.MarketplaceOrdering.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMarketplaceOrderingArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMarketplaceOrderingArmClient"/> class for mocking. </summary>
        protected MockableMarketplaceOrderingArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMarketplaceOrderingArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMarketplaceOrderingArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMarketplaceOrderingArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="MarketplaceAgreementTermResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MarketplaceAgreementTermResource.CreateResourceIdentifier" /> to create a <see cref="MarketplaceAgreementTermResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MarketplaceAgreementTermResource"/> object. </returns>
        public virtual MarketplaceAgreementTermResource GetMarketplaceAgreementTermResource(ResourceIdentifier id)
        {
            MarketplaceAgreementTermResource.ValidateResourceId(id);
            return new MarketplaceAgreementTermResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MarketplaceAgreementResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MarketplaceAgreementResource.CreateResourceIdentifier" /> to create a <see cref="MarketplaceAgreementResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MarketplaceAgreementResource"/> object. </returns>
        public virtual MarketplaceAgreementResource GetMarketplaceAgreementResource(ResourceIdentifier id)
        {
            MarketplaceAgreementResource.ValidateResourceId(id);
            return new MarketplaceAgreementResource(Client, id);
        }
    }
}
