// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Marketplace.Models;

namespace Azure.ResourceManager.Marketplace
{
    internal partial class PrivateStoreRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of PrivateStoreRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public PrivateStoreRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2023-01-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string useCache)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (useCache != null)
            {
                uri.AppendQuery("use-cache", useCache, true);
            }
            return uri;
        }

        internal HttpMessage CreateListRequest(string useCache)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (useCache != null)
            {
                uri.AppendQuery("use-cache", useCache, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the list of available private stores. </summary>
        /// <param name="useCache"> Determines if to use cache or DB for serving this request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<PrivateStoreList>> ListAsync(string useCache = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(useCache);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PrivateStoreList.DeserializePrivateStoreList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the list of available private stores. </summary>
        /// <param name="useCache"> Determines if to use cache or DB for serving this request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<PrivateStoreList> List(string useCache = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(useCache);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PrivateStoreList.DeserializePrivateStoreList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get information about the private store. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<PrivateStoreData>> GetAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PrivateStoreData.DeserializePrivateStoreData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((PrivateStoreData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get information about the private store. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<PrivateStoreData> Get(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PrivateStoreData.DeserializePrivateStoreData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((PrivateStoreData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(Guid privateStoreId, PrivateStoreData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(Guid privateStoreId, PrivateStoreData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Changes private store properties. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="data"> The <see cref="PrivateStoreData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public async Task<Response> CreateOrUpdateAsync(Guid privateStoreId, PrivateStoreData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(privateStoreId, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Changes private store properties. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="data"> The <see cref="PrivateStoreData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public Response CreateOrUpdate(Guid privateStoreId, PrivateStoreData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(privateStoreId, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes the private store. All that is not saved will be lost. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response> DeleteAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes the private store. All that is not saved will be lost. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response Delete(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateDeleteRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateAnyExistingOffersInTheCollectionsRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/anyExistingOffersInTheCollections", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateAnyExistingOffersInTheCollectionsRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/anyExistingOffersInTheCollections", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Query whether exists any offer in the collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<AnyExistingOffersInTheCollectionsResult>> AnyExistingOffersInTheCollectionsAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnyExistingOffersInTheCollectionsRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnyExistingOffersInTheCollectionsResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AnyExistingOffersInTheCollectionsResult.DeserializeAnyExistingOffersInTheCollectionsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query whether exists any offer in the collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<AnyExistingOffersInTheCollectionsResult> AnyExistingOffersInTheCollections(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateAnyExistingOffersInTheCollectionsRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AnyExistingOffersInTheCollectionsResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AnyExistingOffersInTheCollectionsResult.DeserializeAnyExistingOffersInTheCollectionsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateQueryOffersRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryOffers", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateQueryOffersRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryOffers", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List of offers, regardless the collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<QueryOffers>> QueryOffersAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryOffersRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryOffers value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Models.QueryOffers.DeserializeQueryOffers(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List of offers, regardless the collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<QueryOffers> QueryOffers(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryOffersRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryOffers value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Models.QueryOffers.DeserializeQueryOffers(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateQueryUserOffersRequestUri(Guid privateStoreId, QueryUserOffersContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryUserOffers", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateQueryUserOffersRequest(Guid privateStoreId, QueryUserOffersContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryUserOffers", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List of user's approved offers for the provided offers and subscriptions. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="QueryUserOffersContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<QueryOffers>> QueryUserOffersAsync(Guid privateStoreId, QueryUserOffersContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryUserOffersRequest(privateStoreId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryOffers value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = Models.QueryOffers.DeserializeQueryOffers(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List of user's approved offers for the provided offers and subscriptions. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="QueryUserOffersContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<QueryOffers> QueryUserOffers(Guid privateStoreId, QueryUserOffersContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryUserOffersRequest(privateStoreId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryOffers value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = Models.QueryOffers.DeserializeQueryOffers(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateBillingAccountsRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/billingAccounts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateBillingAccountsRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/billingAccounts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Tenant billing accounts names. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<PrivateStoreBillingAccountsResult>> BillingAccountsAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateBillingAccountsRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreBillingAccountsResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PrivateStoreBillingAccountsResult.DeserializePrivateStoreBillingAccountsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Tenant billing accounts names. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<PrivateStoreBillingAccountsResult> BillingAccounts(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateBillingAccountsRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreBillingAccountsResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PrivateStoreBillingAccountsResult.DeserializePrivateStoreBillingAccountsResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCollectionsToSubscriptionsMappingRequestUri(Guid privateStoreId, CollectionsToSubscriptionsMappingContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/collectionsToSubscriptionsMapping", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCollectionsToSubscriptionsMappingRequest(Guid privateStoreId, CollectionsToSubscriptionsMappingContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/collectionsToSubscriptionsMapping", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> For a given subscriptions list, the API will return a map of collections and the related subscriptions from the supplied list. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="CollectionsToSubscriptionsMappingContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<CollectionsToSubscriptionsMappingResult>> CollectionsToSubscriptionsMappingAsync(Guid privateStoreId, CollectionsToSubscriptionsMappingContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCollectionsToSubscriptionsMappingRequest(privateStoreId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CollectionsToSubscriptionsMappingResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CollectionsToSubscriptionsMappingResult.DeserializeCollectionsToSubscriptionsMappingResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> For a given subscriptions list, the API will return a map of collections and the related subscriptions from the supplied list. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="CollectionsToSubscriptionsMappingContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<CollectionsToSubscriptionsMappingResult> CollectionsToSubscriptionsMapping(Guid privateStoreId, CollectionsToSubscriptionsMappingContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateCollectionsToSubscriptionsMappingRequest(privateStoreId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CollectionsToSubscriptionsMappingResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CollectionsToSubscriptionsMappingResult.DeserializeCollectionsToSubscriptionsMappingResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateQueryApprovedPlansRequestUri(Guid privateStoreId, QueryApprovedPlansContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryApprovedPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateQueryApprovedPlansRequest(Guid privateStoreId, QueryApprovedPlansContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryApprovedPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get map of plans and related approved subscriptions. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="QueryApprovedPlansContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<QueryApprovedPlansResult>> QueryApprovedPlansAsync(Guid privateStoreId, QueryApprovedPlansContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryApprovedPlansRequest(privateStoreId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryApprovedPlansResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = QueryApprovedPlansResult.DeserializeQueryApprovedPlansResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get map of plans and related approved subscriptions. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="QueryApprovedPlansContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<QueryApprovedPlansResult> QueryApprovedPlans(Guid privateStoreId, QueryApprovedPlansContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryApprovedPlansRequest(privateStoreId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryApprovedPlansResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = QueryApprovedPlansResult.DeserializeQueryApprovedPlansResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateBulkCollectionsActionRequestUri(Guid privateStoreId, BulkCollectionsActionContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/bulkCollectionsAction", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateBulkCollectionsActionRequest(Guid privateStoreId, BulkCollectionsActionContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/bulkCollectionsAction", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Perform an action on bulk collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="BulkCollectionsActionContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<BulkCollectionsActionResult>> BulkCollectionsActionAsync(Guid privateStoreId, BulkCollectionsActionContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateBulkCollectionsActionRequest(privateStoreId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BulkCollectionsActionResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = BulkCollectionsActionResult.DeserializeBulkCollectionsActionResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Perform an action on bulk collections. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="content"> The <see cref="BulkCollectionsActionContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<BulkCollectionsActionResult> BulkCollectionsAction(Guid privateStoreId, BulkCollectionsActionContent content = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateBulkCollectionsActionRequest(privateStoreId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BulkCollectionsActionResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = BulkCollectionsActionResult.DeserializeBulkCollectionsActionResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetApprovalRequestsListRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetApprovalRequestsListRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get all open approval requests of current user. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<RequestApprovalsList>> GetApprovalRequestsListAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetApprovalRequestsListRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RequestApprovalsList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RequestApprovalsList.DeserializeRequestApprovalsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get all open approval requests of current user. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<RequestApprovalsList> GetApprovalRequestsList(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetApprovalRequestsListRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RequestApprovalsList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RequestApprovalsList.DeserializeRequestApprovalsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestApprovalRequestUri(Guid privateStoreId, string requestApprovalId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequestApprovalRequest(Guid privateStoreId, string requestApprovalId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get open request approval details. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<MarketplaceApprovalRequestData>> GetRequestApprovalAsync(Guid privateStoreId, string requestApprovalId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateGetRequestApprovalRequest(privateStoreId, requestApprovalId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceApprovalRequestData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MarketplaceApprovalRequestData.DeserializeMarketplaceApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((MarketplaceApprovalRequestData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get open request approval details. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<MarketplaceApprovalRequestData> GetRequestApproval(Guid privateStoreId, string requestApprovalId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateGetRequestApprovalRequest(privateStoreId, requestApprovalId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceApprovalRequestData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MarketplaceApprovalRequestData.DeserializeMarketplaceApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((MarketplaceApprovalRequestData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateApprovalRequestRequestUri(Guid privateStoreId, string requestApprovalId, MarketplaceApprovalRequestData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateApprovalRequestRequest(Guid privateStoreId, string requestApprovalId, MarketplaceApprovalRequestData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Create approval request. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="data"> The <see cref="MarketplaceApprovalRequestData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<MarketplaceApprovalRequestData>> CreateApprovalRequestAsync(Guid privateStoreId, string requestApprovalId, MarketplaceApprovalRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateApprovalRequestRequest(privateStoreId, requestApprovalId, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceApprovalRequestData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MarketplaceApprovalRequestData.DeserializeMarketplaceApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Create approval request. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="data"> The <see cref="MarketplaceApprovalRequestData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<MarketplaceApprovalRequestData> CreateApprovalRequest(Guid privateStoreId, string requestApprovalId, MarketplaceApprovalRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateApprovalRequestRequest(privateStoreId, requestApprovalId, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceApprovalRequestData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MarketplaceApprovalRequestData.DeserializeMarketplaceApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateQueryRequestApprovalRequestUri(Guid privateStoreId, string requestApprovalId, QueryApprovalRequestContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendPath("/query", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateQueryRequestApprovalRequest(Guid privateStoreId, string requestApprovalId, QueryApprovalRequestContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendPath("/query", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get request statuses foreach plan, this api is used as a complex GET action. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="content"> The <see cref="QueryApprovalRequestContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<QueryApprovalRequestResult>> QueryRequestApprovalAsync(Guid privateStoreId, string requestApprovalId, QueryApprovalRequestContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateQueryRequestApprovalRequest(privateStoreId, requestApprovalId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryApprovalRequestResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = QueryApprovalRequestResult.DeserializeQueryApprovalRequestResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get request statuses foreach plan, this api is used as a complex GET action. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="content"> The <see cref="QueryApprovalRequestContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<QueryApprovalRequestResult> QueryRequestApproval(Guid privateStoreId, string requestApprovalId, QueryApprovalRequestContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateQueryRequestApprovalRequest(privateStoreId, requestApprovalId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        QueryApprovalRequestResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = QueryApprovalRequestResult.DeserializeQueryApprovalRequestResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateAdminRequestApprovalsListRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateAdminRequestApprovalsListRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get list of admin request approvals. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<MarketplaceAdminApprovalRequestList>> AdminRequestApprovalsListAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateAdminRequestApprovalsListRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MarketplaceAdminApprovalRequestList.DeserializeMarketplaceAdminApprovalRequestList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get list of admin request approvals. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<MarketplaceAdminApprovalRequestList> AdminRequestApprovalsList(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateAdminRequestApprovalsListRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MarketplaceAdminApprovalRequestList.DeserializeMarketplaceAdminApprovalRequestList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetAdminRequestApprovalRequestUri(Guid privateStoreId, string adminRequestApprovalId, string publisherId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals/", false);
            uri.AppendPath(adminRequestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            uri.AppendQuery("publisherId", publisherId, true);
            return uri;
        }

        internal HttpMessage CreateGetAdminRequestApprovalRequest(Guid privateStoreId, string adminRequestApprovalId, string publisherId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals/", false);
            uri.AppendPath(adminRequestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            uri.AppendQuery("publisherId", publisherId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get open approval requests. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="adminRequestApprovalId"> The admin request approval ID to get create or update. </param>
        /// <param name="publisherId"> The publisher id of this offer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminRequestApprovalId"/> or <paramref name="publisherId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="adminRequestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<MarketplaceAdminApprovalRequestData>> GetAdminRequestApprovalAsync(Guid privateStoreId, string adminRequestApprovalId, string publisherId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adminRequestApprovalId, nameof(adminRequestApprovalId));
            Argument.AssertNotNull(publisherId, nameof(publisherId));

            using var message = CreateGetAdminRequestApprovalRequest(privateStoreId, adminRequestApprovalId, publisherId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MarketplaceAdminApprovalRequestData.DeserializeMarketplaceAdminApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((MarketplaceAdminApprovalRequestData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get open approval requests. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="adminRequestApprovalId"> The admin request approval ID to get create or update. </param>
        /// <param name="publisherId"> The publisher id of this offer. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminRequestApprovalId"/> or <paramref name="publisherId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="adminRequestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<MarketplaceAdminApprovalRequestData> GetAdminRequestApproval(Guid privateStoreId, string adminRequestApprovalId, string publisherId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adminRequestApprovalId, nameof(adminRequestApprovalId));
            Argument.AssertNotNull(publisherId, nameof(publisherId));

            using var message = CreateGetAdminRequestApprovalRequest(privateStoreId, adminRequestApprovalId, publisherId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MarketplaceAdminApprovalRequestData.DeserializeMarketplaceAdminApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((MarketplaceAdminApprovalRequestData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateAdminRequestApprovalRequestUri(Guid privateStoreId, string adminRequestApprovalId, MarketplaceAdminApprovalRequestData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals/", false);
            uri.AppendPath(adminRequestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateAdminRequestApprovalRequest(Guid privateStoreId, string adminRequestApprovalId, MarketplaceAdminApprovalRequestData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/adminRequestApprovals/", false);
            uri.AppendPath(adminRequestApprovalId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Update the admin action, weather the request is approved or rejected and the approved plans. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="adminRequestApprovalId"> The admin request approval ID to get create or update. </param>
        /// <param name="data"> The <see cref="MarketplaceAdminApprovalRequestData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminRequestApprovalId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="adminRequestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<MarketplaceAdminApprovalRequestData>> UpdateAdminRequestApprovalAsync(Guid privateStoreId, string adminRequestApprovalId, MarketplaceAdminApprovalRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adminRequestApprovalId, nameof(adminRequestApprovalId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateUpdateAdminRequestApprovalRequest(privateStoreId, adminRequestApprovalId, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MarketplaceAdminApprovalRequestData.DeserializeMarketplaceAdminApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update the admin action, weather the request is approved or rejected and the approved plans. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="adminRequestApprovalId"> The admin request approval ID to get create or update. </param>
        /// <param name="data"> The <see cref="MarketplaceAdminApprovalRequestData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminRequestApprovalId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="adminRequestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<MarketplaceAdminApprovalRequestData> UpdateAdminRequestApproval(Guid privateStoreId, string adminRequestApprovalId, MarketplaceAdminApprovalRequestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adminRequestApprovalId, nameof(adminRequestApprovalId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateUpdateAdminRequestApprovalRequest(privateStoreId, adminRequestApprovalId, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MarketplaceAdminApprovalRequestData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MarketplaceAdminApprovalRequestData.DeserializeMarketplaceAdminApprovalRequestData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateQueryNotificationsStateRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryNotificationsState", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateQueryNotificationsStateRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/queryNotificationsState", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get private store notifications state. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<PrivateStoreNotificationsState>> QueryNotificationsStateAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryNotificationsStateRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreNotificationsState value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PrivateStoreNotificationsState.DeserializePrivateStoreNotificationsState(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get private store notifications state. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<PrivateStoreNotificationsState> QueryNotificationsState(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateQueryNotificationsStateRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreNotificationsState value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PrivateStoreNotificationsState.DeserializePrivateStoreNotificationsState(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateAcknowledgeOfferNotificationRequestUri(Guid privateStoreId, string offerId, AcknowledgeOfferNotificationContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/offers/", false);
            uri.AppendPath(offerId, true);
            uri.AppendPath("/acknowledgeNotification", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateAcknowledgeOfferNotificationRequest(Guid privateStoreId, string offerId, AcknowledgeOfferNotificationContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/offers/", false);
            uri.AppendPath(offerId, true);
            uri.AppendPath("/acknowledgeNotification", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Acknowledge notification for offer. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="offerId"> The offer ID to update or delete. </param>
        /// <param name="content"> The <see cref="AcknowledgeOfferNotificationContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offerId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="offerId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> AcknowledgeOfferNotificationAsync(Guid privateStoreId, string offerId, AcknowledgeOfferNotificationContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(offerId, nameof(offerId));

            using var message = CreateAcknowledgeOfferNotificationRequest(privateStoreId, offerId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Acknowledge notification for offer. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="offerId"> The offer ID to update or delete. </param>
        /// <param name="content"> The <see cref="AcknowledgeOfferNotificationContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offerId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="offerId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response AcknowledgeOfferNotification(Guid privateStoreId, string offerId, AcknowledgeOfferNotificationContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(offerId, nameof(offerId));

            using var message = CreateAcknowledgeOfferNotificationRequest(privateStoreId, offerId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateWithdrawPlanRequestUri(Guid privateStoreId, string requestApprovalId, WithdrawPlanContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendPath("/withdrawPlan", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateWithdrawPlanRequest(Guid privateStoreId, string requestApprovalId, WithdrawPlanContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/requestApprovals/", false);
            uri.AppendPath(requestApprovalId, true);
            uri.AppendPath("/withdrawPlan", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (content != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content0 = new Utf8JsonRequestContent();
                content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
                request.Content = content0;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Withdraw a user request approval on specific plan. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="content"> The <see cref="WithdrawPlanContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> WithdrawPlanAsync(Guid privateStoreId, string requestApprovalId, WithdrawPlanContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateWithdrawPlanRequest(privateStoreId, requestApprovalId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Withdraw a user request approval on specific plan. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="requestApprovalId"> The request approval ID to get create or update. </param>
        /// <param name="content"> The <see cref="WithdrawPlanContent"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestApprovalId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="requestApprovalId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response WithdrawPlan(Guid privateStoreId, string requestApprovalId, WithdrawPlanContent content = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestApprovalId, nameof(requestApprovalId));

            using var message = CreateWithdrawPlanRequest(privateStoreId, requestApprovalId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateFetchAllSubscriptionsInTenantRequestUri(Guid privateStoreId, string nextPageToken)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/fetchAllSubscriptionsInTenant", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateFetchAllSubscriptionsInTenantRequest(Guid privateStoreId, string nextPageToken)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/fetchAllSubscriptionsInTenant", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (nextPageToken != null)
            {
                request.Headers.Add("next-page-token", nextPageToken);
            }
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Fetch all subscriptions in tenant, only for marketplace admin. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="nextPageToken"> The skip token to get the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<SubscriptionsResponse>> FetchAllSubscriptionsInTenantAsync(Guid privateStoreId, string nextPageToken = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateFetchAllSubscriptionsInTenantRequest(privateStoreId, nextPageToken);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SubscriptionsResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SubscriptionsResponse.DeserializeSubscriptionsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Fetch all subscriptions in tenant, only for marketplace admin. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="nextPageToken"> The skip token to get the next page. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<SubscriptionsResponse> FetchAllSubscriptionsInTenant(Guid privateStoreId, string nextPageToken = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateFetchAllSubscriptionsInTenantRequest(privateStoreId, nextPageToken);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SubscriptionsResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SubscriptionsResponse.DeserializeSubscriptionsResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNewPlansNotificationsRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listNewPlansNotifications", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListNewPlansNotificationsRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listNewPlansNotifications", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List new plans notifications. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<NewPlanNotificationListResult>> ListNewPlansNotificationsAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListNewPlansNotificationsRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NewPlanNotificationListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = NewPlanNotificationListResult.DeserializeNewPlanNotificationListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List new plans notifications. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<NewPlanNotificationListResult> ListNewPlansNotifications(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListNewPlansNotificationsRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        NewPlanNotificationListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = NewPlanNotificationListResult.DeserializeNewPlanNotificationListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListStopSellOffersPlansNotificationsRequestUri(Guid privateStoreId, StopSellSubscriptions stopSellSubscriptions)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listStopSellOffersPlansNotifications", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListStopSellOffersPlansNotificationsRequest(Guid privateStoreId, StopSellSubscriptions stopSellSubscriptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listStopSellOffersPlansNotifications", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            if (stopSellSubscriptions != null)
            {
                request.Headers.Add("Content-Type", "application/json");
                var content = new Utf8JsonRequestContent();
                content.JsonWriter.WriteObjectValue(stopSellSubscriptions, ModelSerializationExtensions.WireOptions);
                request.Content = content;
            }
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List stop sell notifications for both stop sell offers and stop sell plans. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="stopSellSubscriptions"> The <see cref="StopSellSubscriptions"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<StopSellOffersPlansNotificationsList>> ListStopSellOffersPlansNotificationsAsync(Guid privateStoreId, StopSellSubscriptions stopSellSubscriptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListStopSellOffersPlansNotificationsRequest(privateStoreId, stopSellSubscriptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        StopSellOffersPlansNotificationsList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = StopSellOffersPlansNotificationsList.DeserializeStopSellOffersPlansNotificationsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List stop sell notifications for both stop sell offers and stop sell plans. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="stopSellSubscriptions"> The <see cref="StopSellSubscriptions"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<StopSellOffersPlansNotificationsList> ListStopSellOffersPlansNotifications(Guid privateStoreId, StopSellSubscriptions stopSellSubscriptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListStopSellOffersPlansNotificationsRequest(privateStoreId, stopSellSubscriptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        StopSellOffersPlansNotificationsList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = StopSellOffersPlansNotificationsList.DeserializeStopSellOffersPlansNotificationsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListSubscriptionsContextRequestUri(Guid privateStoreId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listSubscriptionsContext", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListSubscriptionsContextRequest(Guid privateStoreId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.Marketplace/privateStores/", false);
            uri.AppendPath(privateStoreId, true);
            uri.AppendPath("/listSubscriptionsContext", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List all the subscriptions in the private store context. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<SubscriptionsContextList>> ListSubscriptionsContextAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListSubscriptionsContextRequest(privateStoreId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SubscriptionsContextList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SubscriptionsContextList.DeserializeSubscriptionsContextList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all the subscriptions in the private store context. </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<SubscriptionsContextList> ListSubscriptionsContext(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListSubscriptionsContextRequest(privateStoreId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SubscriptionsContextList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SubscriptionsContextList.DeserializeSubscriptionsContextList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string useCache)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string useCache)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the list of available private stores. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="useCache"> Determines if to use cache or DB for serving this request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<PrivateStoreList>> ListNextPageAsync(string nextLink, string useCache = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));

            using var message = CreateListNextPageRequest(nextLink, useCache);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PrivateStoreList.DeserializePrivateStoreList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the list of available private stores. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="useCache"> Determines if to use cache or DB for serving this request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<PrivateStoreList> ListNextPage(string nextLink, string useCache = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));

            using var message = CreateListNextPageRequest(nextLink, useCache);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PrivateStoreList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PrivateStoreList.DeserializePrivateStoreList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
