// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Marketplace.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Marketplace
{
    public partial class PrivateStoreCollectionInfoData : IUtf8JsonSerializable, IJsonModel<PrivateStoreCollectionInfoData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PrivateStoreCollectionInfoData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PrivateStoreCollectionInfoData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrivateStoreCollectionInfoData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PrivateStoreCollectionInfoData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(CollectionId))
            {
                writer.WritePropertyName("collectionId"u8);
                writer.WriteStringValue(CollectionId.Value);
            }
            if (Optional.IsDefined(CollectionName))
            {
                writer.WritePropertyName("collectionName"u8);
                writer.WriteStringValue(CollectionName);
            }
            if (Optional.IsDefined(Claim))
            {
                writer.WritePropertyName("claim"u8);
                writer.WriteStringValue(Claim);
            }
            if (Optional.IsDefined(AreAllSubscriptionsSelected))
            {
                writer.WritePropertyName("allSubscriptions"u8);
                writer.WriteBooleanValue(AreAllSubscriptionsSelected.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AreAllItemsApproved))
            {
                writer.WritePropertyName("approveAllItems"u8);
                writer.WriteBooleanValue(AreAllItemsApproved.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ApproveAllItemsModifiedOn))
            {
                writer.WritePropertyName("approveAllItemsModifiedAt"u8);
                writer.WriteStringValue(ApproveAllItemsModifiedOn.Value, "O");
            }
            if (Optional.IsCollectionDefined(SubscriptionsList))
            {
                writer.WritePropertyName("subscriptionsList"u8);
                writer.WriteStartArray();
                foreach (var item in SubscriptionsList)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("enabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfOffers))
            {
                writer.WritePropertyName("numberOfOffers"u8);
                writer.WriteNumberValue(NumberOfOffers.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AppliedRules))
            {
                writer.WritePropertyName("appliedRules"u8);
                writer.WriteStartArray();
                foreach (var item in AppliedRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        PrivateStoreCollectionInfoData IJsonModel<PrivateStoreCollectionInfoData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrivateStoreCollectionInfoData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PrivateStoreCollectionInfoData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePrivateStoreCollectionInfoData(document.RootElement, options);
        }

        internal static PrivateStoreCollectionInfoData DeserializePrivateStoreCollectionInfoData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            Guid? collectionId = default;
            string collectionName = default;
            string claim = default;
            bool? allSubscriptions = default;
            bool? approveAllItems = default;
            DateTimeOffset? approveAllItemsModifiedAt = default;
            IList<string> subscriptionsList = default;
            bool? enabled = default;
            long? numberOfOffers = default;
            IReadOnlyList<MarketplaceRule> appliedRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("collectionId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            collectionId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("collectionName"u8))
                        {
                            collectionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("claim"u8))
                        {
                            claim = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("allSubscriptions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allSubscriptions = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("approveAllItems"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            approveAllItems = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("approveAllItemsModifiedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            approveAllItemsModifiedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("subscriptionsList"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            subscriptionsList = array;
                            continue;
                        }
                        if (property0.NameEquals("enabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("numberOfOffers"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfOffers = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("appliedRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<MarketplaceRule> array = new List<MarketplaceRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(MarketplaceRule.DeserializeMarketplaceRule(item, options));
                            }
                            appliedRules = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PrivateStoreCollectionInfoData(
                id,
                name,
                type,
                systemData,
                collectionId,
                collectionName,
                claim,
                allSubscriptions,
                approveAllItems,
                approveAllItemsModifiedAt,
                subscriptionsList ?? new ChangeTrackingList<string>(),
                enabled,
                numberOfOffers,
                appliedRules ?? new ChangeTrackingList<MarketplaceRule>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PrivateStoreCollectionInfoData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrivateStoreCollectionInfoData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PrivateStoreCollectionInfoData)} does not support writing '{options.Format}' format.");
            }
        }

        PrivateStoreCollectionInfoData IPersistableModel<PrivateStoreCollectionInfoData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrivateStoreCollectionInfoData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePrivateStoreCollectionInfoData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PrivateStoreCollectionInfoData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PrivateStoreCollectionInfoData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
