// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> The transfer items response. The response contains two lists that indicate for each collection whether the operation succeeded or failed. </summary>
    public partial class TransferOffersResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TransferOffersResult"/>. </summary>
        internal TransferOffersResult()
        {
            Succeeded = new ChangeTrackingList<PrivateStoreCollectionDetails>();
            Failed = new ChangeTrackingList<PrivateStoreCollectionDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="TransferOffersResult"/>. </summary>
        /// <param name="succeeded"> Succeeded collections. </param>
        /// <param name="failed"> Failed collections. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TransferOffersResult(IReadOnlyList<PrivateStoreCollectionDetails> succeeded, IReadOnlyList<PrivateStoreCollectionDetails> failed, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Succeeded = succeeded;
            Failed = failed;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Succeeded collections. </summary>
        public IReadOnlyList<PrivateStoreCollectionDetails> Succeeded { get; }
        /// <summary> Failed collections. </summary>
        public IReadOnlyList<PrivateStoreCollectionDetails> Failed { get; }
    }
}
