// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> The details to get the request plans statuses. </summary>
    public partial class QueryApprovalRequestContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QueryApprovalRequestContent"/>. </summary>
        public QueryApprovalRequestContent()
        {
            PlanIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="QueryApprovalRequestContent"/>. </summary>
        /// <param name="publisherId"> The offer's publisher id. </param>
        /// <param name="planIds"> Current plans list. </param>
        /// <param name="subscriptionId"> Gets or sets the subscription id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QueryApprovalRequestContent(string publisherId, IList<string> planIds, string subscriptionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherId = publisherId;
            PlanIds = planIds;
            SubscriptionId = subscriptionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The offer's publisher id. </summary>
        public string PublisherId { get; set; }
        /// <summary> Current plans list. </summary>
        public IList<string> PlanIds { get; }
        /// <summary> Gets or sets the subscription id. </summary>
        public string SubscriptionId { get; set; }
    }
}
