// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> Plan accessibility. </summary>
    public readonly partial struct PrivateStorePlanAccessibility : IEquatable<PrivateStorePlanAccessibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrivateStorePlanAccessibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrivateStorePlanAccessibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PublicValue = "Public";
        private const string PrivateTenantOnLevelValue = "PrivateTenantOnLevel";
        private const string PrivateSubscriptionOnLevelValue = "PrivateSubscriptionOnLevel";

        /// <summary> Unknown. </summary>
        public static PrivateStorePlanAccessibility Unknown { get; } = new PrivateStorePlanAccessibility(UnknownValue);
        /// <summary> Public. </summary>
        public static PrivateStorePlanAccessibility Public { get; } = new PrivateStorePlanAccessibility(PublicValue);
        /// <summary> PrivateTenantOnLevel. </summary>
        public static PrivateStorePlanAccessibility PrivateTenantOnLevel { get; } = new PrivateStorePlanAccessibility(PrivateTenantOnLevelValue);
        /// <summary> PrivateSubscriptionOnLevel. </summary>
        public static PrivateStorePlanAccessibility PrivateSubscriptionOnLevel { get; } = new PrivateStorePlanAccessibility(PrivateSubscriptionOnLevelValue);
        /// <summary> Determines if two <see cref="PrivateStorePlanAccessibility"/> values are the same. </summary>
        public static bool operator ==(PrivateStorePlanAccessibility left, PrivateStorePlanAccessibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrivateStorePlanAccessibility"/> values are not the same. </summary>
        public static bool operator !=(PrivateStorePlanAccessibility left, PrivateStorePlanAccessibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrivateStorePlanAccessibility"/>. </summary>
        public static implicit operator PrivateStorePlanAccessibility(string value) => new PrivateStorePlanAccessibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrivateStorePlanAccessibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrivateStorePlanAccessibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
